package Paths;

use strict;

use Tools;

use Cwd 'abs_path';
use File::Basename;

###############################################################################

sub new {
    my ($class, $params) = @_;

    my $self = bless {}, $class;
    if ($params) { $self->init($params); }

    return $self;
}

sub init {
    my ($self, $params) = @_;

    $self->{params} = $params;
    $self->{options} = Tools::options($params->{input});
    $self->{dots} = Tools::dots($params->{input});
    $self->{lines} = [];
}

sub do {
    my ($self) = @_;

    my $paths = $self->_paths();

    my $out_dir = $self->{params}->{output};
    $out_dir =~ s{/[^/]*$}{};
    $out_dir = abs_path($out_dir);
    $out_dir =~ s{^$Tools::lego/}{};

    my @blockPaths = split(':', $self->{params}->{paths});
    for my $blockPath (@blockPaths) {
        if ($blockPath !~ m{/$}) {
            $blockPath .= "/";
        }
        for my $path (@$paths) {
            $self->_push($path, $blockPath);
        }
    }

    $self->_out();
}

sub _out {
    my ($self) = @_;

    my $output = $self->{params}->{output} . $self->{params}->{suffix};
    open(F, ">$output");
    print F $self->_header();
    print F $self->_lines();
    print F $self->_footer();
    close(F);
}

###############################################################################

sub _paths {
    my ($self) = @_;

    my $paths = [];
    my %uniq;
    my $input = $self->{params}->{input};
    open(F, "xsltproc --xinclude $Tools::tools/xml2paths.xsl $input |");
    while (<F>) {
        chomp;
        if (!$uniq{$_}) {
            push(@$paths, $_);
            $uniq{$_}++;
        }
    }
    close(F);
    return $paths;
}

sub _push {
    my ($self, $line, $prefix) = @_;

    my $lines = $self->{lines};
    my $suffix = $self->{params}->{suffix};

    push(@$lines, $prefix . $line . $suffix);
}

sub _lines {
    my ($self, $re, $nre) = @_;

    my $lego = $Tools::lego;
    my $dots = $self->{dots};

    my $lines = $self->{lines};
    # Жуткий костыль, позволяющий фильтровать список строк двумя регэкспами
    # TODO: переписать все заново
    my @lines = ($re or $nre) ? grep { ($re) ? $_ =~ $re : 1 and ($nre) ? $_ !~ $nre : 1 } @$lines : @$lines;

    my $result = '';
    for my $line (@lines) {
        if (-e "$line") {
            $result .= $self->_line( Tools::rel_path("$line", $self->{params}->{output} . $self->{params}->{suffix}) );
        }
    }
    return $result;
}

sub _header { return ''; }
sub _footer { return ''; }

###############################################################################

1;

