package Paths::CSS;

use strict;
use Paths;
use Tools;

our(@ISA);

@ISA = qw( Paths );

sub _out {
    my ($self) = @_;

    if ($self->{options}->{'separate-hover'}) {

        my $output = $self->{params}->{output} . $self->{params}->{suffix};
        open(F, ">$output");
        print F $self->_header();
        print F $self->_lines(undef, qr/\.hover/);
        print F $self->_footer();
        close(F);

        $output = $self->{params}->{output} . ".hover" . $self->{params}->{suffix};
        open(F, ">$output");
        print F <<CSS;
/* Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. */ /**/

CSS
        print F $self->_lines(qr/\.hover/);
        print F $self->_footer();
        close(F);

    } else {
        $self->SUPER::_out();
    }
}

sub _push {
    my ($self, $line, $prefix) = @_;

    my $lines = $self->{lines};
    my $suffix = $self->{params}->{suffix};

    if ($self->{options}->{'css-need-reset'}) {
        push(@$lines, $prefix . $line . ".reset" . $suffix);
    }
    push(@$lines, $prefix . $line . ".hover" . $suffix);
    push(@$lines, $prefix . $line . $suffix);
}

sub _line {
    my ($self, $line) = @_;

    return qq|\@import url($line);\n|;
}

sub _header {
    my ($self) = @_;

    my $suffix = $self->{params}->{suffix};
    my $dots = Tools::dots($self->{params}->{output});

    my $r = <<CSS;
/* Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. */ /**/

CSS

    if (!$self->{params}->{ieonlycss} eq 1) {
        if ($self->{params}->{suffix} eq '.ie.css') {
            $r .= $self->_line( Tools::rel_path($self->{params}->{output} . '.css', $self->{params}->{output} . $self->{params}->{suffix}) );
        } elsif ($self->{params}->{suffix} eq '.ie6.css') {
            $r .= $self->_line( Tools::rel_path($self->{params}->{output} . '.ie.css', $self->{params}->{output} . $self->{params}->{suffix}) );
        } elsif ($self->{params}->{suffix} eq '.ie7.css') {
            $r .= $self->_line( Tools::rel_path($self->{params}->{output} . '.ie.css', $self->{params}->{output} . $self->{params}->{suffix}) );
        }
    }

    return $r;
}

1;

