package Paths::XSL;

use strict;
use Paths;
use Tools;

our(@ISA);

@ISA = qw( Paths );

sub _line {
    my ($self, $line) = @_;

    return qq|<xsl:import href="$line"/>\n|;
}

sub _header {
    my ($self) = @_;

    my $dots = Tools::dots($self->{params}->{output});
    my $output = $self->{options}->{'xsl-output'} || '';

    my $result = <<XSL;
<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
XSL
    if ($output eq 'xhtml' || $output eq 'xhtml-mobile') {
        $result .= <<XSL;
    xmlns:x="http://www.yandex.ru/xscript"
XSL
    }

    $result .= <<XSL;
    version="1.0">

<!-- Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. -->
XSL

    if ($self->{params}->{suffix} eq '.convert2xml.xsl') {
        $result .= <<XSL;

<xsl:import href="$dots/tools/convert2xml.xsl"/>

XSL
    }

    return $result;
}

sub _footer {
    my ($self) = @_;

    my $output = $self->{options}->{'xsl-output'} || '';

    my $r = "\n";

    if ($self->{params}->{suffix} eq '.convert2xml.xsl') {
        $r .= <<XSL;
<xsl:output method="xml" indent="yes" encoding="utf-8"/>

XSL
    } elsif ($output eq 'html') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="html"
    indent="no"
    media-type="text/html"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    omit-xml-declaration="yes"
/>

XSL
    } elsif ($output eq 'xhtml') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="x:xhtml"
    indent="no"
    media-type="text/html"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    omit-xml-declaration="yes"
/>

XSL
    } elsif ($output eq 'xhtml-mobile') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="x:xhtml"
    indent="no"
    media-type="text/html"
    doctype-system="http://www.wapforum.org/DTD/xhtml-mobile10.dtd"
    doctype-public="-//WAPFORUM//DTD XHTML Mobile 1.0//EN"
    omit-xml-declaration="yes"
/>

XSL
    } elsif ($output eq 'html-mobile') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="html"
    indent="no"
    media-type="text/html"
    doctype-system="http://www.wapforum.org/DTD/xhtml-mobile10.dtd"
    doctype-public="-//WAPFORUM//DTD XHTML Mobile 1.0//EN"
    omit-xml-declaration="yes"
/>

XSL
    } elsif ($output eq 'html5') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="html"
    indent="no"
    media-type="text/html"
    omit-xml-declaration="yes"
/>

<xsl:template match="lego:b-page" xmlns:lego="https://lego.yandex-team.ru">
    <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html></xsl:text>
    <xsl:apply-imports/>
</xsl:template>

XSL
     } elsif ($output eq 'quirks') {
         $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="html"
    indent="no"
    media-type="text/html"
    omit-xml-declaration="yes"
/>

<xsl:template match="lego:b-page" xmlns:lego="https://lego.yandex-team.ru">
    <xsl:apply-imports/>
</xsl:template>

XSL
    } elsif ($output eq 'mobile') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="html"
    indent="no"
    media-type="text/html"
    doctype-system="http://www.wapforum.org/DTD/xhtml-mobile10.dtd"
    doctype-public="-//WAPFORUM//DTD XHTML Mobile 1.0//EN"
    omit-xml-declaration="yes"
/>

XSL
    } elsif ($output eq 'json') {
        $r .= <<XSL;
<xsl:output
    encoding="UTF-8"
    method="text"
    indent="no"
    media-type="text/javascript"
    omit-xml-declaration="yes"
/>

XSL
    }

    $r .= <<XSL;
</xsl:stylesheet>
XSL

    return $r;
}

1;

