if (process.argv.length < 3) {
    process.stderr.write('Usage: \nnode b-suggest_to_b-head-search_suggest.js index.raw.xml\n');
    process.exit(1);
}

var xml = require('o3-xml');
var fs = require('fs');


function up(element, name) {
    var parent = element;
    while (parent && parent.tagName != name) {
        parent = parent.parentNode;
    }
    return parent;
}


process.argv.slice(2).forEach(function(fileName) {
    
    var text = fs.readFileSync(fileName, 'utf8');
    var doc = xml.parseFromString(text);

    /*
     * https://github.com/ajaxorg/node-o3-xml/issues/20
     */
    var bSuggests = doc.documentElement.selectNodes("descendant-or-self::node()[name() = 'lego:b-suggest']");
    for (var i = 0; i < bSuggests.length; i++) {
        var bSuggest = bSuggests[i];
        var input = up(bSuggest, 'input');
        if (input) {
            var bFormInputs = input.selectNodes("descendant-or-self::node()[name() = 'lego:b-form-input']");
            for (var j = 0; j < bFormInputs.length; j++) {
                var bFormInput = bFormInputs[j];
                bFormInput.setAttribute('lego:autocomplete', 'yes');
                bFormInput.setAttribute('lego:is-bem', 'yes');
                var dataprovider = doc.createElement('lego:dataprovider');
                dataprovider.setAttribute('url', bSuggest.getAttribute('url'));
                bFormInput.appendChild(dataprovider);
            }
            var bHeadSearch = up(input, 'b-head-search');
            if (bHeadSearch) {
                bHeadSearch.setAttribute('lego:suggest', 'yes');
                bHeadSearch.setAttribute('lego:is-bem', 'yes');
            }
            bSuggest.parentNode.removeChild(bSuggest);
        }
    }

    process.stdout.write(doc.documentElement.toString());

});
