var myPath = require('bem/lib/path');

exports.techs = {
    '2lego.xsl': './techs/nodejs/2lego.xsl.js',
    'xsl':       './techs/nodejs/xsl.js',
    'js':        './techs/nodejs/js.js',
    'css':       './techs/nodejs/css.js',

    'deps.js':   './techs/nodejs/deps.js.js',

    'decl.js':   './techs/nodejs/decl.js.js',
    'decl.xml':  './techs/nodejs/decl.xml.js',

    'title.txt': './techs/nodejs/title.txt.js',
    'desc.wiki': './techs/nodejs/desc.wiki.js',
    'wiki':      './techs/nodejs/wiki.js',

    'xml': './techs/nodejs/xml.js',
    'blocks': './techs/nodejs/blocks.js',

    'convert2xml.xsl': './techs/nodejs/convert2xml.xsl.js',
    'xhtml.xsl':       './techs/nodejs/xhtml.xsl.js'
};

for (var alias in exports.techs)
    exports.techs[alias] = myPath.absolute(exports.techs[alias], __dirname);

exports.defaultTechs = ['css', 'js', 'xsl', 'title.txt', 'desc.wiki'];

exports['get-elem'] = function(block, elem) {
    return [block,
           elem,
           block + '__' + elem].join('/');
};

exports['get-elem-mod'] = function(block, elem, mod) {
    if (elem == 'examples') {
        return [block, elem, mod].join('/');
    }

    return [block,
        elem,
        '_' + mod,
        block + '__' + elem + '_' + mod].join('/');
};

exports['get-elem-mod-val'] = function(block, elem, mod, val) {
    if (elem == 'examples') {
        return [block, elem, mod + '_' + val].join('/');
    }

    return [block,
        elem,
        '_' + mod,
        block + '__' + elem + '_' + mod + '_' + val].join('/');
};

exports['match-elem'] = function(path) {
    var m = this.matchRe(),
        match = (new RegExp(['^(' + m + ')',
        '(' + m + ')',
        '\\1__\\2(.*?)$'].join('/'))).exec(path);
    if (!match) return false;
    return {
        block: match[1],
        elem: match[2],
        suffix: match[3]
    };
};

exports['match-elem-mod'] = function(path) {
    var match = this.match('examples-mod', path);
    if (match) return match;

    var m = this.matchRe();
    match = (new RegExp(['^(' + m + ')',
        '(' + m + ')',
        '_(' + m + ')',
        '\\1__\\2_\\3(.*?)$'].join('/'))).exec(path);
    if (!match) return false;
    return {
        block: match[1],
        elem: match[2],
        mod: match[3],
        suffix: match[4]
    };
};

exports['match-elem-mod-val'] = function(path) {
    var match = this.match('examples-mod-val', path);
    if (match) return match;

    var m = this.matchRe();
    match = (new RegExp(['^(' + m + ')',
        '(' + m + ')',
        '_(' + m + ')',
        '\\1__\\2_\\3_(' + m + ')(.*?)$'].join('/'))).exec(path);
    if (!match) return false;
    return {
        block: match[1],
        elem: match[2],
        mod: match[3],
        val: match[4],
        suffix: match[5]
    };
};

exports['match-examples-mod'] = function(path) {
    var m = this.matchRe(),
        match = (new RegExp(['^(' + m + ')',
            '(examples)',
            '(' + m + ')(.*?)$'].join('/'))).exec(path);
    if (!match) return false;
    return {
        block: match[1],
        elem: match[2],
        mod: match[3],
        suffix: match[4]
    };
};

exports['match-examples-mod-val'] = function(path) {
    var m = this.matchRe(),
        match = (new RegExp(['^(' + m + ')',
            '(examples)',
            '(' + m + ')_(' + m + ')(.*?)$'].join('/'))).exec(path);
    if (!match) return false;
    return {
        block: match[1],
        elem: match[2],
        mod: match[3],
        val: match[4],
        suffix: match[5]
    };
};

exports.isIgnorablePath = function(path) {
    return (/\.(git|svn)$/.test(path) ||
        /(GNU|MAC)?Makefile/.test(path) ||
        /\/examples\/.*?\.make\./.test(path) ||
        /\/examples\/.*?\.(png|jpe?g|gif|svg|tt2)$/.test(path));
};
