exports.techModule = module;
exports.bemBuild = function (prefixes, outputDir, outputName) {
    var _this = this,
        content = ['<?xml version="1.0" encoding="utf-8"?>',
        '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">',
        ''].join('\n');
    this.filterExists(prefixes)
        .map(function (file) {
            return file.from(outputDir);
        })
        .forEach(function (file) {
            content += _this.outFile(file);
        });
    content += '\n</xsl:stylesheet>\n';
    outputDir.join(outputName + '.' + this.getTechName()).write(content);
    return this;
};


exports.outFile = function (file) {
    return '<xsl:import href="' + file + '"/>\n';
};
