var fs = require('file');

exports.techModule = module;

function bemBuildContent(prefixes, suffixes, outputDir) {

    var files = [];

    prefixes.forEach(function (prefix) {
        suffixes.forEach(function (suffix) {
            var file = fs.path(prefix + '.' + suffix);
            file.exists() && files.push(file);
        });
    });

    return files
        .map(function (file) {
            return exports.outFile(file.from(outputDir));
        })
        .join('');

}

exports.bemBuild = function (prefixes, outputDir, outputName) {

    var cssName = outputName + '.css';

    outputDir.join(cssName)
        .write(bemBuildContent(prefixes, ['hover.css', 'css'], outputDir));

    outputDir.join(outputName + '.ie.css')
        .write(
            this.outFile(cssName) +
            bemBuildContent(prefixes, ['hover.ie.css', 'ie.css'], outputDir));

    return this;

};


exports.outFile = function (file) {
    return '@import url(' + file + ');\n';
};
