var myPath = require('bem/lib/path'),
    fs = require('fs');

exports.techModule = module;
exports.bemBuild = function (prefixes, outputDir, outputName) {
    var _this = this,
        content = ['<?xml version="1.0" encoding="utf-8"?>',
        '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">',
        ''].join('\n');
    this.filterExists(prefixes)
        .map(function (file) {
            return myPath.relative(outputDir, file);
        })
        .forEach(function (file) {
            content += _this.outFile(file);
        });
    content += '\n</xsl:stylesheet>\n';

    var filename = myPath.join(
        outputDir,
        this.fileByPrefix(outputName)
    );

    fs.writeFileSync(filename, content);

    return this;
};


exports.outFile = function (file) {
    return '<xsl:import href="' + file + '"/>\n';
};
