var myPath = require('bem/lib/path'),
    fs = require('fs'),
    bemUtil = require('bem/lib/util'),
    Template = require('bem/lib/template');

exports.techModule = module;

exports.bemBuildContent = function(prefixes, suffixes, outputDir) {

    var files = [],
        _this = this;

    prefixes.forEach(function (prefix) {
        suffixes.forEach(function (suffix) {
            var file = prefix + '.' + suffix;
            bemUtil.isFile(file) && files.push(file);
        });
    });

    return files
        .map(function (file) {
            return _this.outFile(myPath.relative(outputDir, file));
        })
        .join('');

};

exports.bemBuild = function (prefixes, outputDir, outputName) {

    var prefix = myPath.join(outputDir, outputName),
        cssName = prefix + '.css';

    this.write(
        cssName,
        this.bemBuildContent(prefixes, ['hover.css', 'css'], outputDir));

    this.write(
        prefix + '.ie.css',
        this.outFile(myPath.relative(outputDir, cssName)) +
            this.bemBuildContent(prefixes, ['hover.ie.css', 'ie.css'], outputDir));

    return this;

};

exports.outFile = function (file) {
    return '@import url(' + file + ');\n';
};

exports.newFileContent = function (vars) {
    vars.Selector = '.' + vars.BlockName +
        (vars.ElemName? '__' + vars.ElemName : '') +
        (vars.ModVal? '_' + vars.ModName + '_' + vars.ModVal : '');

    return Template.process([
        '{{bemSelector}}',
        '{',
        '    /* ... */',
        '}'],
        vars);
};

exports.write = function(file, content) {
    fs.writeFileSync(file, content);
};
