var fs = require('fs'),
    path = require('path'),
    json4xml = require(path.join(fs.realpathSync(__dirname), '../../../json4xml')).json4xml;

exports.techModule = module;

// .decl.xml не собираются при вызове bem build
exports.bemBuild = function(prefixes, outputDir, outputName) {};

exports.newFileContent = function(vars) {
    var decl = this.getContext().getLevel().getBlockByIntrospection(vars.BlockName),
        block = [
        'block',
        {name: vars.BlockName},
        [].concat((decl.mods || []).map(mod2json4xml))
            .concat((decl.elems || []).map(elem2json4xml))
    ];
    return '<?xml version="1.0" encoding="utf-8"?>\n' +
        formatXml(json4xml(block));
};

function mod2json4xml(mod) {
    return [
        'mod',
        {name: mod.name},
        mod.vals ? mod.vals.map(function(v){ return val2json4xml(v.name) }) : []
    ];
}

function val2json4xml(val) {
    return ['val', {name: val}, []]
}

function elem2json4xml(elem){
    return [
        'elem',
        {name: elem.name},
        elem.mods ? elem.mods.map(mod2json4xml) : []
    ]
}

/**
 *	Pretty prints xml
 *
 *	@param	String	ugly xml
 *	@return	String	prettier xml
 *	@author Schell Scivally
 *	@since	Sun Mar 14 16:16:50 PDT 2010
 */
function formatXml(xml) {
	var reg = /(>)(<)(\/*)/g;
	var wsexp = / *(.*) +\n/g;
	var contexp = /(<.+>)(.+\n)/g;
	xml = xml.replace(reg, '$1\n$2$3').replace(wsexp, '$1\n').replace(contexp, '$1\n$2');
	var pad = 0;
	var formatted = '';
	var lines = xml.split('\n');
	var indent = 0;
	var lastType = 'other';
	// 4 types of tags - single, closing, opening, other (text, doctype, comment) - 4*4 = 16 transitions
	var transitions = {
		'single->single'    : 0,
		'single->closing'   : -1,
		'single->opening'   : 0,
		'single->other'     : 0,
		'closing->single'   : 0,
		'closing->closing'  : -1,
		'closing->opening'  : 0,
		'closing->other'    : 0,
		'opening->single'   : 1,
		'opening->closing'  : 0, // if there's an open to a close, they probably should have used a single, oh well
		'opening->opening'  : 1,
		'opening->other'    : 1,
		'other->single'     : 0,
		'other->closing'    : -1,
		'other->opening'    : 0,
		'other->other'      : 0
	};

	for (var i=0; i < lines.length; i++) {
		var ln = lines[i];
		var single = /<.+\/>/.test(ln); // is this line a single tag? ex. <br />
		var closing = /<\/.+>/.test(ln); // is this a closing tag? ex. </a>
		var opening = /<[^!].*>/.test(ln); // is this even a tag (that's not <!something>)
		var type = single ? 'single' : closing ? 'closing' : opening ? 'opening' : 'other';
		var fromTo = lastType + '->' + type;
		lastType = type;
		var padding = '';

		indent += transitions[fromTo];
		for (var j = 0; j < indent; j++) {
			padding += '    ';
		}

		formatted += padding + ln + '\n';
	}

	return formatted;
}
