var myPath = require('bem/lib/path'),
    css = require('./css');
for (var n in css) exports[n] = css[n];

exports.techModule = module;

exports.bemBuild = function (prefixes, outputDir, outputName) {

    var prefix = myPath.join(outputDir, outputName) + '.';

    this.write(
        prefix  + this.getTechName(),
        this.outFile(myPath.relative(outputDir, prefix + 'bemhtml.js')) +
            this.bemBuildContent(prefixes, ['js'], outputDir));

    return this;

};

exports.outFile = function (file) {
    return 'include("' + file + '");\n';
};
