var myPath = require('bem/lib/path'),
    Template = require('bem/lib/template'),
    fs = require('fs');

exports.techModule = module;

exports.bemBuild = function(prefixes, outputDir, outputName) {
    var filename = myPath.join(
          outputDir,
          this.fileByPrefix(outputName)
        ),
        content = this.xslStylesheet(
          this.xslFiles(prefixes, outputDir, outputName)
        );

    fs.writeFileSync(filename, content);

    return this;
};

exports.xslStylesheet = function(content) {
    return ['<?xml version="1.0" encoding="utf-8"?>',
        '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">', '',
        content,
        '', '</xsl:stylesheet>'].join('\n');
};

exports.xslFiles = function(prefixes, outputDir, outputName) {
    var _this = this;
    return this
        .filterExists(prefixes)
        .map(function (file) {
            return _this.outFile(myPath.relative(outputDir, file));
        }).join('');
};

exports.outFile = function (file) {
    return '<xsl:import href="' + file + '"/>\n';
};

exports.newFileContent = function (vars) {
    vars.Match = 'lego:' + vars.BlockName +
        (vars.ElemName? '/lego:' + vars.ElemName : '') +
        (vars.ModVal?
            '[@lego:' + vars.ModName + " = '" + vars.ModVal + "']" :
            (vars.ModName? '[@lego:' + vars.ModName + ']' : ''));

    var jsParams = !vars.ElemName? [
        '',
        '            <xsl:apply-templates select="." mode="lego:js-params"/>',
        ].join('\n') : '';

    return Template.process([
        '<?xml version="1.0" encoding="utf-8"?>',
        '<xsl:stylesheet',
        '    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"',
        '    xmlns:x="http://www.yandex.ru/xscript"',
        '    xmlns:lego="https://lego.yandex-team.ru"',
        '    exclude-result-prefixes=" x lego "',
        '    version="1.0">',
        '',
        '    <xsl:template match="{{bemMatch}}">',
        '        <div>',
        '            <xsl:apply-templates select="." mode="lego:block-attributes"/>' + jsParams,
        '            <xsl:apply-templates select="." mode="lego:content"/>',
        '        </div>',
        '    </xsl:template>',
        '',
        '</xsl:stylesheet>'], vars);
};
