exports.techModule = module;

exports.bemBuild = function(prefixes, outputDir, outputName) {
    outputDir.join(outputName + '.' + this.getTechName())
        .write(this.xslStylesheet(
            this.xslFiles(prefixes, outputDir, outputName)));

    return this;
};

exports.xslStylesheet = function(content) {
    return ['<?xml version="1.0" encoding="utf-8"?>',
        '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">', '',
        content,
        '', '</xsl:stylesheet>'].join('\n');
};

exports.xslFiles = function(prefixes, outputDir, outputName) {
    var _this = this;
    return this
        .filterExists(prefixes)
        .map(function (file) {
            return _this.outFile(file.from(outputDir));
        }).join('');
};

exports.outFile = function (file) {
    return '<xsl:import href="' + file + '"/>\n';
};
