<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE stylesheet [
  <!ENTITY cr "
">
]>
<xsl:stylesheet
    xmlns:local="local"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:func="http://exslt.org/functions"
    exclude-result-prefixes=" func"
    extension-element-prefixes=" func "
    version="1.0">

    <xsl:output
        encoding="utf-8"
        method="text"/>

    <xsl:template match="/">
        <xsl:apply-templates select="status/target/entry"/>
        <xsl:text>&cr;</xsl:text>
    </xsl:template>
    
    <xsl:template match="status/target/entry"/>

    <xsl:template match="status/target/entry[wc-status/@item='modified']">
        <xsl:if test="local:ends-with(@path, 'debian/control')
            or local:ends-with(@path, '/i-common.xsl')
            or local:ends-with(@path, '.wiki')
            or local:ends-with(@path, '.wiki.xml')
            or local:ends-with(@path, '.raw.xml')">
            <xsl:value-of select="@path"/>
            <xsl:text> </xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template match="status/target/entry[wc-status/@item='unversioned']">
        <xsl:if test="local:ends-with(@path, '.wiki')
            or local:ends-with(@path, '.wiki.xml')">
            <xsl:value-of select="@path"/>
            <xsl:text> </xsl:text>
        </xsl:if>
    </xsl:template>

    <func:function name="local:ends-with">
        <xsl:param name="str1"/>
        <xsl:param name="str2"/>
        <func:result select="number(substring($str1, string-length($str1) - string-length($str2) + 1) = $str2)"/>
    </func:function>

</xsl:stylesheet>
