<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    xmlns:xi="http://www.w3.org/2001/XInclude"
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes=" lego xi func exsl "
    extension-element-prefixes=" func exsl "
    version="1.0">

<xsl:variable name="id" select="/lego:page/global/id"/>

<xsl:variable name="blocks-suffix">
    <xsl:if test="/lego:page[global/mobile]">-mobile</xsl:if>
    <xsl:if test="/lego:page[global/intranet]">-intranet</xsl:if>
</xsl:variable>

<xsl:param name="locale" select="'ru'"/>

<xsl:variable name="services" select="document(concat('../blocks', $blocks-suffix, '/i-services/common.', $locale, '.xml'))/lego:services/lego:service"/>
<xsl:variable name="messages" select="document(concat('../blocks', $blocks-suffix, '/i-messages/messages.', $locale, '.xml'))/lego:messages/lego:message"/>

<!-- ############################################################################################################## -->

<xsl:template match="/">
    <xsl:copy-of select="processing-instruction('xml-stylesheet')"/>
    <xsl:comment> Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. </xsl:comment>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="lego:page">
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <lego:i-common>
            <lego:attributes/>
            <lego:items/>
        </lego:i-common>
        <lego:declaration>
            <lego:i-common>
                <lego:border-radius/>
            </lego:i-common>
            <lego:i-counter/>
            <lego:i-common>
                <lego:cookie/>
                <lego:check-session/>
                <lego:init/>
            </lego:i-common>
        </lego:declaration>
        <xsl:if test="not(//lego:i-oframebust[not(ancestor::lego-declaration ) and @lego:type])">
            <lego:i-oframebust lego:type="html"/>
        </xsl:if>
        <lego:i-global lego:type="{global/css-global}"/>
        <xsl:apply-templates select="*|text()"/>

        <xsl:if test="global/need-localization">
            <lego:i-locale/>
        </xsl:if>
        <xsl:if test="$locale != 'ru'">
            <xsl:copy-of select="document(concat('../blocks', $blocks-suffix, '/i-messages/messages.', $locale, '.xml'))/*"/>
        </xsl:if>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:mix">
    <lego:declaration>
        <xsl:apply-templates select="." mode="lego:declaration"/>
    </lego:declaration>
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="lego:mix/lego:*[@b]" mode="lego:declaration">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="lego:mix/lego:*[@b]" mode="lego:declaration">
    <xsl:element name="{@b}" namespace="https://lego.yandex-team.ru">
        <xsl:copy-of select="."/>
    </xsl:element>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="*|@*">
    <xsl:copy>
        <xsl:apply-templates select="." mode="content"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="*|@*" mode="content">
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="*|text()"/>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:service">
<xsl:param name="service-id" select="$id"/>
    <func:result select="$services[@id = $service-id]"/>
</func:function>

<func:function name="lego:service-name">
<xsl:param name="service-id" select="$id"/>
<xsl:variable name="service" select="$services[@id = $service-id]"/>
    <func:result>
        <xsl:choose>
            <xsl:when test="@name != ''">
                <xsl:value-of select="@name"/>
            </xsl:when>
            <xsl:when test="$service != ''">
                <xsl:value-of select="$service"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </func:result>
</func:function>

</xsl:stylesheet>
