<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    extension-element-prefixes="x ya"
    >

    <xsl:output
        encoding="UTF-8"
        method="text"
    />

    <xsl:param name="output" select="'json'"/>

    <xsl:template match="/">
        <xsl:apply-templates/>
        <xsl:text>&#10;</xsl:text>
    </xsl:template>

    <xsl:template match="*">
        <xsl:if test="position() - 1">,</xsl:if>
        <xsl:text>{</xsl:text>
            <xsl:apply-templates select="@name"/>
            <xsl:if test="@title">
                <xsl:text>,</xsl:text>
                <xsl:apply-templates select="@title"/>
            </xsl:if>
            <xsl:apply-templates select="." mode="mods"/>
            <xsl:apply-templates select="." mode="vals"/>
            <xsl:apply-templates select="." mode="elems"/>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template match="@*">
        <xsl:value-of select="name()"/>
        <xsl:text>:'</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>'</xsl:text>
    </xsl:template>

    <xsl:template match="decl">
        <xsl:if test="$output = 'module'">exports.blocks = </xsl:if>
        <xsl:text>[</xsl:text>
            <xsl:apply-templates select="block"/>
        <xsl:text>]</xsl:text>
        <xsl:if test="$output = 'module'">;</xsl:if>
    </xsl:template>

    <xsl:template match="*" mode="mods"/>
    <xsl:template match="*[mod]" mode="mods">
        <xsl:text>,mods:[</xsl:text>
            <xsl:apply-templates select="mod"/>
        <xsl:text>]</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="vals"/>
    <xsl:template match="*[val]" mode="vals">
        <xsl:text>,vals:[</xsl:text>
            <xsl:apply-templates select="val"/>
        <xsl:text>]</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="elems"/>
    <xsl:template match="*[elem]" mode="elems">
        <xsl:text>,elems:[</xsl:text>
            <xsl:apply-templates select="elem"/>
        <xsl:text>]</xsl:text>
    </xsl:template>

</xsl:stylesheet>
