<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:xs="http://www.w3.org/2001/XMLSchema">

    <xsl:output encoding="utf-8" method="xml"/>

    <xsl:template match="/">
        <xs:schema
            targetNamespace="https://lego.yandex-team.ru"
            xmlns:xs="http://www.w3.org/2001/XMLSchema">
            <xsl:apply-templates select="block" mode="block"/>
            <xsl:apply-templates select="block" mode="type"/>
            <xsl:apply-templates select="block" mode="block-elems-types"/>
        </xs:schema>
    </xsl:template>

    <xsl:template match="block" mode="block">
        <xs:element name="{@name}">
            <xsl:attribute name="type">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
        </xs:element>
    </xsl:template>

    <xsl:template match="block" mode="type">
        <xs:complexType name="{@name}">
            <xsl:if test="elem">
                <xs:sequence>
                    <xsl:apply-templates select="elem" mode="elem"/>
                </xs:sequence>
            </xsl:if>
            <xsl:apply-templates select="mod"/>
            <xsl:comment> NOTE: хак для возможности проксирования произвольных параметров из атрибутов блока в js </xsl:comment>
            <xs:anyAttribute/>
        </xs:complexType>
    </xsl:template>

    <xsl:template match="elem" mode="type">
        <xs:complexType name="{concat(../@name, '_', @name)}">
            <xsl:apply-templates select="mod"/>
        </xs:complexType>
    </xsl:template>

    <xsl:template match="elem" mode="elem">
        <xs:element name="{concat('lego:', @name)}">
            <xsl:attribute name="type">
                <xsl:value-of select="concat(../@name, '_', @name)"/>
            </xsl:attribute>
        </xs:element>
    </xsl:template>

    <xsl:template match="block" mode="block-elems-types">
        <xsl:apply-templates select="elem" mode="type"/>
    </xsl:template>

    <xsl:template match="mod">
        <xs:attribute name="{concat('lego:', @name)}">
            <xs:simpleType>
                <xsl:apply-templates select="val"/>
            </xs:simpleType>
        </xs:attribute>
    </xsl:template>

    <xsl:template match="val">
        <xs:enumeration value="{@name}"/>
    </xsl:template>

</xsl:stylesheet>
