<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes="lego"
    >

<xsl:template match="lego:b-js-example">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>

        <span class="{lego:name(.)}__content">
            <xsl:apply-templates select="." mode="lego:text"/>
        </span>

        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-form-button lego:valign="middle" lego:theme="grey-19" lego:height="19" type="button">
                    <lego:mix>
                        <lego:run b="b-js-example"/>
                    </lego:mix>
                    <lego:left/>
                    <lego:content>
                        <lego:text>Запустить</lego:text>
                    </lego:content>
                    <lego:input type="button"/>
                </lego:b-form-button>
                <lego:output b="b-js-example"/>
            </xsl:with-param>
        </xsl:call-template>

        <span class="{concat(lego:name(.), '__output')}"/>
    </div>
</xsl:template>

</xsl:stylesheet>
