<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exslt="http://exslt.org/common"
    extension-element-prefixes="x ya exslt"
    exclude-result-prefixes="lego"
    >

    <xsl:template match="lego:b-page/lego:head" mode="lego:js-content">
        <xsl:value-of select="concat('_type/_eval_type_', x:get-state-arg('type'), '.js')"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:css-content">
        <xsl:value-of select="concat('_type/_eval_type_', x:get-state-arg('type'))"/>
    </xsl:template>

    <!-- TODO: убрать после соответствующих изменений в blocks/b-page/b-page.xsl -->
    <xsl:template match="lego:b-page/lego:head[lego:js]" mode="lego:js">
        <xsl:apply-templates select="." mode="lego:common-js"/>
        <xsl:apply-templates select="lego:js"/>
    </xsl:template>
    <xsl:template match="lego:b-page/lego:head[lego:css]" mode="lego:css">
        <xsl:call-template name="lego:css">
            <xsl:with-param name="meta" select="false()"/>
            <xsl:with-param name="css">
                <xsl:apply-templates select="." mode="lego:css-content"/>
            </xsl:with-param>
            <!-- TODO: унести этот костыль ближе в mobile -->
            <xsl:with-param name="media">
                <xsl:if test="x:get-state-arg('type') = 'blocks-mobile'">screen,handheld</xsl:if>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:apply-templates select="lego:css"/>
    </xsl:template>


</xsl:stylesheet>
