<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    exclude-result-prefixes="lego"
    >

    <xsl:template match="/">
        <xsl:value-of select="x:http-header-out('Content-Type', 'text/html; charset=UTF-8')"/>
        <xsl:apply-templates select="lego:page/lego:b-page"/>
    </xsl:template>

    <xsl:template match="/" mode="lego:params">
        <xsl:copy-of select="/lego:page/lego:params/*"/>
        <lego:static-host/>
        <lego:yandexuid><xsl:value-of select="x:get-cookie('yandexuid')"/></lego:yandexuid>
        <lego:i-oframebust>
            <lego:all-allowed/>
        </lego:i-oframebust>
    </xsl:template>

    <!-- TODO: убрать после соответствующих изменений в blocks/b-page/b-page.xsl -->
    <xsl:template match="lego:b-page/lego:head[lego:js]" mode="lego:js">
        <xsl:apply-templates select="." mode="lego:common-js"/>
        <xsl:apply-templates select="lego:js"/>
    </xsl:template>
    <xsl:template match="lego:b-page/lego:head[lego:css]" mode="lego:css">
        <xsl:call-template name="lego:css">
            <xsl:with-param name="meta" select="false()"/>
            <xsl:with-param name="css">
                <xsl:apply-templates select="." mode="lego:css-content"/>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:apply-templates select="lego:css"/>
    </xsl:template>

</xsl:stylesheet>
