<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output encoding="UTF-8" method="xml" omit-xml-declaration="yes"/>

    <xsl:template match="block">
        <xsl:apply-templates select="." mode="elems"/>
        <xsl:apply-templates select="." mode="mods"/>
    </xsl:template>

    <xsl:template match="block[@name = 'i-global']"/>

    <xsl:template match="block" mode="elems">
        <xsl:element name="{concat('lego:', @name)}">
            <xsl:apply-templates select="elem"/>
        </xsl:element>
    </xsl:template>
    <xsl:template match="block[mod]" mode="elems"/>

    <xsl:template match="elem">
        <xsl:apply-templates select="." mode="mods"/>
    </xsl:template>

    <!-- Игнорируем «элемент» блока examples -->
    <xsl:template match="elem[@name = 'examples']"/>

    <xsl:template match="*" mode="mods">
        <xsl:variable name="name" select="concat('lego:', @name)"/>
        <xsl:for-each select="mod/val">
            <xsl:element name="{$name}">
                <xsl:attribute name="{concat('lego:', ../@name)}">
                    <xsl:value-of select="@name"/>
                </xsl:attribute>
                <xsl:if test="not(../preceding-sibling::mod)">
                    <xsl:apply-templates select="../../elem"/>
                </xsl:if>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="elem[not(mod/val)]" mode="mods">
        <xsl:element name="{concat('lego:', @name)}"/>
    </xsl:template>

</xsl:stylesheet>
