<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output encoding="UTF-8" method="xml"/>

    <xsl:param name="xml" select="false()"/>

    <xsl:template match="/*">
        <fake-root>
            <xsl:choose>
                <xsl:when test="$xml">
                    <xsl:apply-templates select="." mode="xml"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="param"/>
                </xsl:otherwise>
            </xsl:choose>
        </fake-root>
    </xsl:template>

    <xsl:template match="param"/>

    <xsl:template match="param[starts-with(@name, 'lego-css')]">
        <lego:css>
            <xsl:attribute name="lego:ie">
                <xsl:choose>
                    <xsl:when test="contains(@name, '-ie')">only</xsl:when>
                    <xsl:otherwise>no</xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:choose>
                <xsl:when test="not(contains(@name, '-file'))">
                    <xsl:attribute name="lego:inline">yes</xsl:attribute>
                    <xsl:value-of select="."/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="contains(., '.ie.css')">
                            <xsl:value-of select="substring-before(., '.ie.css')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="substring-before(., '.css')"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </lego:css>
    </xsl:template>

    <xsl:template match="param[starts-with(@name, 'lego-js')]">
        <lego:js>
            <xsl:if test="not(contains(@name, '-file'))">
                <xsl:attribute name="lego:inline">yes</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="."/>
        </lego:js>
    </xsl:template>

    <xsl:template match="*" mode="xml">
        <xsl:variable name="nodes" select="x:xmlparse(self::state/*[name() = $xml])/*"/>
        <xsl:choose>
            <xsl:when test="$nodes">
                <xsl:apply-templates select="$nodes" mode="lego"/>
            </xsl:when>
            <xsl:otherwise>
                <lego:b-eval-error/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="*" mode="lego">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()" mode="lego"/>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
