<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xi="http://www.w3.org/2001/XInclude"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes=""
    version="1.0">

    <xsl:param name="example-name"/>
    <xsl:param name="example-params" select="''"/>
    <xsl:param name="example-css" select="''"/>
    <xsl:param name="example-ie-css" select="''"/>
    <xsl:param name="example-js" select="''"/>

    <xsl:template match="/lego:page">
        <xsl:processing-instruction name="xml-stylesheet">
            <xsl:text>type="text/xsl" href="</xsl:text>
            <xsl:value-of select="$example-name"/>
            <xsl:text>.xsl"</xsl:text>
        </xsl:processing-instruction>
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="lego:name">
                <xsl:value-of select="string($example-name)"/>
            </xsl:attribute>

            <global>
                <id>lego</id>
                <css-global>reset</css-global>
            </global>

            <x:xscript http-expire-time-delta="0">
                <x:add-headers>
                    <x:header name="Cache-Control" value="max-age=0, proxy-revalidate"/>
                </x:add-headers>
            </x:xscript>

            <lego:declaration>
                <lego:i-domain-lower/>
            </lego:declaration>

            <lego:params>
                <xi:include href="../../../../configs/current/lego-params.xml" xpointer="xpointer(/*/*)"/>
                <xsl:if test="string($example-params)">
                    <xsl:copy-of select="document($example-params)/*/*"/>
                </xsl:if>
            </lego:params>

            <lego:b-page>
                <lego:head>
                    <xsl:if test="string($example-css)">
                        <lego:css lego:ie="no">
                            <xsl:text>../../</xsl:text>
                            <xsl:value-of select="substring($example-css, 1, string-length($example-css) - 4)"/>
                        </lego:css>
                    </xsl:if>
                    <xsl:if test="string($example-ie-css)">
                        <lego:css lego:ie="only">
                            <xsl:text>../../</xsl:text>
                            <xsl:value-of select="substring($example-ie-css, 1, string-length($example-ie-css) - 7)"/>
                        </lego:css>
                    </xsl:if>
                    <xsl:if test="string($example-js)">
                        <lego:js>
                            <xsl:text>../../</xsl:text>
                            <xsl:value-of select="substring($example-js, 1, string-length($example-js) - 3)"/>
                        </lego:js>
                    </xsl:if>
                </lego:head>
                <xsl:apply-templates/>
            </lego:b-page>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*">
        <xsl:copy-of select="."/>
    </xsl:template>

</xsl:stylesheet>
