#!/usr/bin/ruby -W0

#
# from22to23.rb
# Tool for migration from lego <= 2.2 to lego >= 2.3
# 
# Created by seriously drunken on 20.12.09
#

REPLACE_FILES_EXT_LIST = /\.(css|txt|wiki|html|xsl)$/i

class String

    def directory?
        File.directory? self
    end

    def red; colorize("\e[31m"); end

    def green; colorize("\e[32m"); end

    def yellow; colorize("\e[33m"); end

    def blue; colorize("\e[34m"); end

    def block?
        match /^[bigl]-[a-z-]+$/i
    end

    def element?
        match(/^[a-z][a-z0-9-]+$/i) and not %w(i-static examples).include? self
    end
    
    def modificator?
        match /^_[a-z][a-z0-9-]+$/i
    end

    private

    # Функция для подсвечивания строки с помошью ANSI кодов...
    def colorize code
        unless PLATFORM =~ /win32/
            "#{code}#{self}\e[0m"
        else
            self
        end
    end

end

def has_modifications? path
    `svn st #{path}` =~ /^(M|A|D|\?)\s{7}/im
end

if ARGV.empty? or not(File.exists? ARGV.first) or not(File.directory? ARGV.first)
    puts DATA.read
    exit 1
end

lego_path = File.expand_path ARGV.first

blocks = Array.new
params = Array.new

unless ARGV.shift.empty?
    ARGV.each do |name|
        name.strip!
        if name.block?
            blocks.push name
        end
        if name =~ /^--(.*?)$/
            params.push $1
        end
    end
end

unless blocks.empty?
    blocks.map! do |block|
        if has_modifications? "#{lego_path}/#{block}"
            puts "#{block} будет пропущен т.к. в нем есть какие то незакомиченные изменения"
        else
            block
        end
    end
else
    if has_modifications? lego_path
        puts "Please do svn revert or svn commit before migrate"
        exit 1
    end
end

blocks.compact!

file_list = []
name_list = []

Dir["#{lego_path}/*"].each do |block_path|

    block_name = File.basename block_path

    next unless block_path.directory? and block_name.block?
    next unless blocks.empty? or blocks.include? block_name

    block_dirs = Dir["#{block_path}/**/*"].map { |path| path if path.directory? and path !~ /i-static|examples/ }.delete_if { |path| path.nil? }
    
    next if block_dirs.empty?

    file_list.push :action => :skip, :message => block_name
    block_dirs.each do |block_dir_path|
        
        file_path = block_dir_path.gsub(/^#{block_path}\//, '').split '/'
        level = file_path.length

        new_name, old_name, alm_name = [block_name] * 3
        file_path.each do |segment|
            if segment.element?
                new_name = "#{new_name}__#{segment}"
                old_name = "#{old_name}.#{segment}"
                alm_name = "#{alm_name}__#{segment}"
            elsif segment.modificator?
                new_name = "#{new_name}#{segment}"
                old_name = "#{old_name}_"
                alm_name = "#{alm_name}_"
            else
                file_list.push :action => :skip, :message => "#{''.ljust(level * 4)}    #{file_path.last}".ljust(50) + " => " + "имя папки не похоже ни на модификатор, ни на элемент".red
                next
            end
        end

        file_list.push :action => :skip, :message => ''.ljust(level * 4) + file_path.last

        Dir["#{block_dir_path}/*"].each do |entry_path|

            next if entry_path.directory?
            
            file_name = File.basename entry_path

            start = ''
            case file_name
                when /^#{new_name}/
                    file_list.push :action => :skip, :message => "#{''.ljust(level * 4)}    #{file_name}".ljust(50) + " => #{file_name.yellow}"
                    next
                when /^#{old_name}/
                    start = old_name
                when /^#{alm_name}/
                    start = alm_name
                else
                    file_list.push :action => :skip, :message => "#{''.ljust(level * 4)}    #{file_name}".ljust(50) + " => " + "имя файла не похоже, ни на новое, ни на старое".red
                    next
            end

            name = "#{new_name}#{old_name =~ /_$/ ? '_' : ''}#{file_name.gsub(/^#{start}/, '')}"
            item = { :message => "#{''.ljust(level * 4)}    #{file_name}".ljust(50) + " => #{name.green}", :source => entry_path, :target => "#{File.dirname entry_path}/#{name}" }

            if file_name =~ REPLACE_FILES_EXT_LIST
                new_css_name = name.gsub(/\..*?$/, '')
                old_css_name = start
                old_ext_name = file_name.gsub(start, '').split '.'
                old_css_name = "#{old_css_name}#{old_ext_name.first}" unless old_ext_name.first.empty?
                old_css_name = old_css_name.gsub(/\./, '__')

                unless new_css_name.eql? old_css_name
                    name_list.push :old => old_css_name, :new => new_css_name
                end

                item[:action] = :rename_and_replace
            else
                item[:action] = :rename
            end

            file_list.push item

        end

    end

end

name_list = name_list.uniq
name_list = name_list.sort do |x, y|
    y[:old].length <=> x[:old].length
end

file_list.each do |item|

    puts item[:message]
    next if item[:action].eql? :skip or params.include? 'test'

    unless item[:action].eql? :rename
        meat = open(item[:source]).read
        name_list.each_with_index do |name, index|
            meat.gsub! name[:old], "%%#{index}%%"
        end
        name_list.each_with_index do |name, index|
            meat.gsub! /%%#{index}%%/, name[:new]
        end
        open(item[:source], 'w') do |f|
            f.puts meat
        end
    end
    `svn mv #{item[:source]} #{item[:target]}`

end

__END__
Usage:
    ruby from22to23.rb path_to_blocks_dir                           # обновить все блоки в папке
    ruby from22to23.rb path_to_blocks_dir b-foot l-page b-button    # обновить только указанные блоки

    ruby from22to23.rb path_to_blocks_dir b-foot l-page b-button --test
