<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<xsl:output
    method="xml"
    encoding="utf-8"
    />

<xsl:template match="/">
    <xsl:if test="processing-instruction() != ''">
        <xsl:processing-instruction name='xml-stylesheet'>
            <xsl:value-of select="processing-instruction()"/>
        </xsl:processing-instruction>
    </xsl:if>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="* | @*">
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates select="node()"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="@lego:dropdowna"/>

<xsl:template match="*[local-name() = 'lua']//text()">
    <xsl:value-of select="'&lt;![CDATA['" disable-output-escaping="yes"/>
    <xsl:value-of select="." disable-output-escaping="yes"/>
    <xsl:value-of select="']]&gt;'" disable-output-escaping="yes"/>
</xsl:template>

<xsl:template match="lego:b-suggest/@lego:close[. = 'close']"/>

<xsl:template match="lego:b-search//lego:button">
    <xsl:copy>
        <lego:b-form-button type="submit"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-head-search//lego:b-search//lego:button">
    <xsl:copy>
        <lego:b-form-button type="submit" lego:height="22" lego:theme="grey-no-transparent-22"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-search//lego:input">
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <lego:b-form-input lego:isBEM="yes">
            <xsl:copy-of select="@id | @name | @shortcut"/>
            <xsl:if test="@focus">
                <xsl:attribute name="autofocus">yes</xsl:attribute>
            </xsl:if>
            <xsl:if test="ancestor::lego:b-head-search">
                <xsl:attribute name="lego:size">16</xsl:attribute>
            </xsl:if>
            <lego:input/>
            <xsl:apply-templates select=".//lego:b-hint-input"/>
        </lego:b-form-input>
        <xsl:copy-of select="lego:*"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-search//lego:input/@*[
    name() = 'name' or
    name() = 'id' or
    name() = 'focus' or
    name() = 'shortcut']"/>

<xsl:template match="lego:b-search//lego:input[lego:b-form-input]">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="lego:b-search//lego:input//lego:b-hint-input">
    <lego:hint>
        <xsl:apply-templates/>
    </lego:hint>
</xsl:template>

</xsl:stylesheet>
