<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:json="urn:yandex:json"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    xmlns:str="http://exslt.org/strings"
    exclude-result-prefixes="lego"
    extension-element-prefixes="func str"
    >

    <xsl:output
        encoding="UTF-8"
        method="text"
        indent="no"
        media-type="text/javascript"
        omit-xml-declaration="yes"
    />

    <xsl:include href="xml2json.xsl"/>


    <xsl:template match="lego:*">
        <xsl:apply-templates select="." mode="json"/>
    </xsl:template>

    <xsl:template match="lego:*" mode="json">
        <xsl:text>{</xsl:text>
            <xsl:apply-templates select="." mode="bem-item"/>
            <xsl:apply-templates select="." mode="bem-mods"/>
            <xsl:if test="not(lego:is-block(.))">
                <!--<xsl:variable name="block" select="@b | ancestor::lego:*[not(current()/@b)][lego:is-block(.)][1]"/>-->
                <xsl:variable name="block" select="@b"/>
                <xsl:if test="$block">
                    <xsl:text>,</xsl:text>
                    <xsl:apply-templates select="$block" mode="bem-item"/>
                </xsl:if>
            </xsl:if>
            <xsl:call-template name="json-comma-separated">
                <xsl:with-param name="nodes" select="@*[not(namespace-uri() = 'https://lego.yandex-team.ru')]"/>
                <xsl:with-param name="need-first" select="true()"/>
            </xsl:call-template>
            <xsl:apply-templates select="." mode="json-comma-separated"/>
            <xsl:apply-templates select="." mode="json-content"/>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template match="lego:declaration" mode="json"/>

    <xsl:template match="lego:*" mode="json-comma-separated"/>


    <xsl:template match="lego:*/@b" mode="bem-item">
        <xsl:text>"block":</xsl:text>
        <xsl:value-of select="json:quote(.)"/>
    </xsl:template>

    <xsl:template match="lego:*" mode="bem-item">
        <xsl:text>"</xsl:text>
        <xsl:apply-templates select="." mode="bem-item-key"/>
        <xsl:text>":</xsl:text>
        <xsl:value-of select="json:quote(local-name())"/>
    </xsl:template>

    <xsl:template match="lego:*" mode="bem-item-key">elem</xsl:template>
    <xsl:template match="lego:*[lego:is-block(.)]" mode="bem-item-key">block</xsl:template>


    <xsl:template match="lego:*" mode="bem-mods"/>
    <xsl:template match="lego:*[@lego:*]" mode="bem-mods">
        <xsl:text>,"</xsl:text>
        <xsl:apply-templates select="." mode="bem-mods-key"/>
        <xsl:text>":{</xsl:text>
        <xsl:call-template name="json-comma-separated">
            <xsl:with-param name="nodes" select="@*[namespace-uri() = 'https://lego.yandex-team.ru']"/>
        </xsl:call-template>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template match="lego:*" mode="bem-mods-key">elemMods</xsl:template>
    <xsl:template match="lego:*[lego:is-block(.)]" mode="bem-mods-key">mods</xsl:template>


    <xsl:template match="lego:*/@lego:*" mode="json">
        <xsl:value-of select="json:quote(local-name())"/>
        <xsl:text>:</xsl:text>
        <xsl:value-of select="json:quote(.)"/>
    </xsl:template>


    <xsl:template name="json-comma-separated">
        <xsl:param name="nodes"/>
        <xsl:param name="need-first" select="false()"/>
        <xsl:for-each select="$nodes">
            <xsl:if test="position() - 1 or $need-first">,</xsl:if>
            <xsl:apply-templates select="." mode="json"/>
        </xsl:for-each>
    </xsl:template>

    <func:function name="lego:is-block">
        <xsl:param name="node"/>
        <func:result select="translate(substring(local-name($node), 1, 2), 'blegzi', '') = '-'"/>
    </func:function>

</xsl:stylesheet>
