/**
 * Записывает *.decl.xml файлы для заданного блока.
 */

if (process.argv.length < 4) {
    console.log('Not enough params');
    process.exit(1);
};

var json4xml = require('./json4xml').json4xml,
    lego = new (require('./lego').Lego)(process.argv[2]),
    util = require('./util');

var blockName = process.argv[3],
    block = [
        'block',
        {name: blockName},
        [].concat(lego.getModsFromFileSys(blockName).map(mod2json4xml))
            .concat(lego.getElemsFromFileSys(blockName).map(elem2json4xml))
    ];

util.writeFile(
    lego.getBlockFilePrefix(blockName) + '.decl.xml',
    '<?xml version="1.0" encoding="utf-8"?>\n' + json4xml(block) + '\n'
);


function mod2json4xml(mod) {
    return [
        'mod',
        {name: mod.name},
        mod.vals.map(function(v){ return val2json4xml(v.name) })
    ];
}

function val2json4xml(val) {
    return ['val', {name: val}, []]
}

function elem2json4xml(elem){
    return [
        'elem',
        {name: elem.name},
        elem.mods.map(mod2json4xml)
    ]
}
