/**
 * Записывает *.wiki файлы для заданного блока.
 */

if (process.argv.length < 4) {
    console.log('Not enough params');
    process.exit(1);
}

var blocks = process.argv[2].replace(/\/+$/, ''),
    lego = new (require('./lego').Lego)(process.argv[2]),
    writeFileIfDiffers = require('./util').writeFileIfDiffers,
    block = lego.getBlockFromFileSys(process.argv[3]),
    wiki = '';

wiki += '%%html\n<lego:b-static-text xmlns:lego="https://lego.yandex-team.ru">\n%%\n\n';
wiki += '== ' + wikiTitleAndName(block) + '\n\n' +
    '%%html\n<lego:b-docs>\n%%\n\n' +
    block.desc + '\n' +
    (block.mods.length ? '=== Модификаторы блока\n' + wikiMods(block.mods, '') : '') +
    (block.elems.length ? '\n=== Элементы блока\n' + wikiElems(block.elems) : '') +
    '\n%%html\n</lego:b-docs>\n%%\n\n' +
    (block.psd.length ?
    '%%html\n\n' +
    '<h4>PSD-файл: ' +
    ( block.psd.map(function(psd){
        return '' +
        '<lego:b-link url="/' + psd.path + '">' + psd.file + '</lego:b-link>\n'
    })) + '</h4>' +
    '\n%%\n\n' : '') +
    (examples(block));
    wiki += '%%html\n</lego:b-static-text>\n%%\n\n';

function examples(block) {
    if (blocks == 'blocks-touch') {
        // Заляпа для touch-блоков
        return block.examples.length == 0? '' : '' +
        '\n=== Примеры блока\n\n' +
        '%%html\n\n' +
            '<lego:b-link url="examples">Входные данные (bemjson)</lego:b-link>\n' +
            '<lego:b-link url="/sets/common-touch/' + block.name + '/examples">Результат (html)</lego:b-link>\n' +
        '\n%%\n\n' +
        '';
    }
    return block.examples.length ?
        '%%html\n<lego:b-examples>\n%%\n\n' +
        '\n=== Примеры блока\n\n' +
        '%%html\n\n' +
            block.examples.map(function(example) {
                var tabs = exampleTabs(example.source, blocks);

                return '<lego:b-example block="' + block.name + '" example="' + example.name + '" lego:is-bem="yes"' + (blocks == 'blocks-mobile' ? ' type="mobile"' : '') + '>\n' +
                    '<lego:title>' + example.title.replace(/\n*$/, '') + '</lego:title>\n' +
                    '<lego:description>' + (example.desc ? '\n%%\n\n' + example.desc + '\n%%html\n' : '') + '</lego:description>\n' +
                    '<lego:b-tabbed-pane lego:is-bem="yes">' +
                        '<lego:mix>' +
                            '<lego:code b="b-example"/>' +
                        '</lego:mix>\n' +
                        '<lego:tabs>' +
                           '<lego:b-menu lego:layout="horiz-complex" lego:is-bem="yes" lego:togglable="yes">\n' +
                                tabs.join('') +
                            '</lego:b-menu>\n' +
                        '</lego:tabs>\n' +
                        '<lego:panels lego:is-bem="yes">' +
                        examplePanels(example.source) +
                        '</lego:panels>' +
                    '</lego:b-tabbed-pane>' +
                '</lego:b-example>';
            }).join('\n') +
            '\n</lego:b-examples>\n%%\n\n'
        :
        ''
}

function exampleTabs(sources, blocks) {
    var tabs = [];
    for (var s in sources) {
        if (!sources[s]) continue;
        var link = sources[s];
        if (s == 'html')
            link += (blocks != 'blocks' ? '&amp;type=' + blocks : '') +
                (blocks == 'blocks-mobile' ? '&amp;mode=mobile': '');
        else
            link = '/' + link;

        tabs.push('<lego:item type="' + s + '">\n' +
            '<lego:mix>\n' +
                '<lego:link b="b-example"/>\n' +
                '<lego:tab b="b-tabbed-pane"/>\n' +
                '<lego:item-selector b="b-menu"/>\n' +
            '</lego:mix>\n' +
            '<lego:b-pseudo-link url="' + link + '" lego:is-bem="yes">' + s + '</lego:b-pseudo-link>\n' +
        '</lego:item>\n');
    }
    return tabs;
}


function examplePanels(sources) {
    var panels = [];
    for (var key in sources) {
        if (!sources[key]) continue;
        panels.push('<lego:panel>' +
            '<lego:b-codemirror lego:mode="' + key + '" lego:is-bem="yes"/>' +
            '<lego:submit b="b-example">показать результат</lego:submit>' +
        '</lego:panel>');
    }
    return panels.join('');
}

function wikiElems(elems) {
    return elems.map(function(e){
            return '\n%%html\n<a name="element.' + e.name + '"></a>\n%%\n\n' +
                '* **' + wikiTitleAndName(e) + '**.\n \\\\' +
                (e.desc || '\n') +
                (e.mods.length ? '    * **Модификаторы элемента блока**\n' + wikiMods(e.mods, '    ') : '')
        }).join('')
}

function wikiMods(mods, level) {
    return mods.map(function(m){
            return level + '  * ' + wikiTitleAndName(m) + '\n \\\\' +
                (m.desc || '\n') +
                m.vals.map(function(v){
                    return level + '    * ' + wikiTitleAndName(v) + '\n'
                }).join('')
        }).join('')
}

function wikiTitleAndName(o) {
    return '##' + o.name + '##: ' + o.title.trim();
}

writeFileIfDiffers(lego.getBlockFilePrefix(block.name) + '.wiki', wiki);
