# ================================ Переменные

LEGO_REPO ?= svn.yandex.ru/lego
LEGO_PATH ?= trunk
LEGO_REV ?= HEAD
LEGO_PARTS ?= bem-bl/blocks-common tools

SVN ?= svn
SVN_PROTOCOL ?= svn+ssh

# ================================ Функции

DO_LEGO_SVN ?= $(call DO_SVN,$(LEGO_REPO)/$(LEGO_PATH)/$1,$(LEGO_REV),$(LEGO_PREFIX)$1)

DO_SVN ?= echo -- $(SVN) $1@$2 $3; \
	if [ -d $3 -a "`$(SVN) info $3 | grep URL | sed "s/URL.*\/\///"`" = $1 ]; \
	then \
		$(SVN) up -r $2 $3; \
	else \
		if [ -d $3 ]; \
		then \
			rm -rf $3; \
		fi \
		&& $(SVN) co -r $2 $(SVN_PROTOCOL)://$1 $3; \
	fi

# ================================ Цели

LEGO_TARGETS ?= $(foreach p,$(LEGO_PARTS),$(LEGO_PREFIX)$p.get)
LEGO_DIRS ?= $(foreach p,$(LEGO_PARTS),$(LEGO_PREFIX)$p)

.PHONY: lego.get
lego.get:: $(LEGO_TARGETS)

.PHONY: $(LEGO_TARGETS)
$(LEGO_TARGETS)::
	@$(call DO_LEGO_SVN,$(patsubst $(LEGO_PREFIX)%.get,%,$@))

.PHONY: lego.clean
lego.clean::
	-rm -rf $(LEGO_PREFIX)

.PHONY: lego.st
lego.st::
	$(SVN) st $(LEGO_DIRS)

.PHONY: lego.diff
lego.diff::
	$(SVN) diff $(LEGO_DIRS)
