# ================================ Includes

ifneq ($(MAKEFILE_LIST),)
__lego_make_root := $(word $(words $(MAKEFILE_LIST)),$(MAKEFILE_LIST))

# If there are any spaces in the path in __lego_make_root then give up

ifeq (1,$(words $(__lego_make_root)))
__lego_make_root := $(patsubst %platform.mk,%,$(__lego_make_root))
else
__lego_make_root :=
endif

include $(__lego_make_root)common.mk
include $(__lego_make_root)configs.mk
include $(__lego_make_root)ycssjs.mk
include $(__lego_make_root)get-lego.mk

else

include common.mk
include configs.mk
include ycssjs.mk
include get-lego.mk

endif


# ================================ Переменные, задающие окружение

# NOTE: С обязательным / в конце, если значение не пустое
LEGO_PREFIX ?= lego/

# NOTE: С обязательным / в конце, если значение не пустое
PRJ_PREFIX ?=

# Все уровни переопределения: blocks* bem-bl/blocks*
LEGO_BLOCK_LEVELS ?= $(shell ls -d -1 $(LEGO_PREFIX)blocks* $(LEGO_PREFIX)blocks*/blocks*)

# Все уровни переопределения: blocks*
PRJ_BLOCK_LEVELS ?= $(shell ls -d -1 $(PRJ_PREFIX)blocks*)

# Все типы страниц: pages*
PRJ_PAGE_LEVELS ?= $(shell ls -d -1 $(PRJ_PREFIX)pages*)

# Собирать Лего-блоки
BUILD_LEGO_BLOCK_LEVELS ?= false

# Собирать проектные блоки
BUILD_PRJ_BLOCK_LEVELS ?= false

# Собирать проектные страницы
BUILD_PRJ_PAGE_LEVELS ?= true


# ================================ Цели

.PHONY: all-levels
all-levels:: ;


# Собирать Лего-блоки
ifeq ($(BUILD_LEGO_BLOCK_LEVELS),true)

all-levels:: $(LEGO_BLOCK_LEVELS)

# Динамическая генерация целей для уровней переопределения Лего
$(call generate_block_level_targets,$(LEGO_PREFIX),$(LEGO_BLOCK_LEVELS))

endif


# Собирать проектные блоки
ifeq ($(BUILD_PRJ_BLOCK_LEVELS),true)

ifneq ($(LEGO_PREFIX),$(PRJ_PREFIX))
# Динамическая генерация целей для уровней переопределения проекта
$(call generate_block_level_targets,$(PRJ_PREFIX),$(PRJ_BLOCK_LEVELS))

all-levels:: $(PRJ_BLOCK_LEVELS)
endif

endif


.PHONY: all-pages
all-pages:: ;

# Собирать проектные страницы
ifeq ($(BUILD_PRJ_PAGE_LEVELS),true)

all-pages:: $(PRJ_PAGE_LEVELS)

# Динамическая генерация целей для всех уровней страниц проекта pages*
$(call generate_page_level_targets,$(PRJ_PREFIX),$(PRJ_PAGE_LEVELS))

endif
