.PHONY: all
all:: ;

# ================================ Переменные

PAGES_TECHS_raw.xml ?= xhtml.xsl css js
PAGES_TECHS_bemjson.js ?= bemhtml css js pub.js
PAGES_TECHS_bemdecl.js ?= bemhtml css js

PAGES_SUFFIXES_bemjson.js ?= html
PAGES_SUFFIXES_bemdecl.js ?= html


# ================================ Includes

ifneq ($(MAKEFILE_LIST),)
__lego_make_root := $(word $(words $(MAKEFILE_LIST)),$(MAKEFILE_LIST))

# If there are any spaces in the path in __lego_make_root then give up

ifeq (1,$(words $(__lego_make_root)))
__lego_make_root := $(patsubst %sets.mk,%,$(__lego_make_root))
else
__lego_make_root :=
endif

include $(__lego_make_root)common.mk

else

include common.mk

endif

# ================================ Переменные

YENV ?= development

EXAMPLES ?= $(shell find $(SET_SOURCE) -not -name '*.params.*' \( -wholename '*/examples/*.xml' -o -wholename '*/examples/*.bemjson.js' \) -not \( -name '.svn' -prune \) | sed -e 's~$(SET_SOURCE)/~~;s~.xml$$~~;s~.bemjson.js$$~~')


# ================================ Функции

# Динамическая генерация целей для примеров
# $(1) - Путь-префикс
# $(2) - Пути до примеров: blocks/b-blocks/examples/10block_bem blocks/b-blocks/examples/20block_xml
generate_block_examples_targets=$(foreach example,$(2),\
$(eval $(call PAGE_template,$(1)/,$(call get_parent,$(call get_parent,$(example))),$(call get_parent,$(call get_parent,$(example))),$(call get_parent,$(example)),$(example))))


# ================================ Сборка примеров

# Дополнительные цели для примеров (все пути предваряются $(LEGO_PREFIX))
# $(1) - Путь-префикс: blocks/
# $(2) - Директория уровня страницы: blocks/b-block
# $(3) - Дочерняя директория страницы: blocks/b-block
# $(4) - Директория страницы: blocks/b-block/examples
# $(5) - Префикс для собираемых файлов страницы: blocks/b-block/examples/example-name
define after_PAGE_template

.PHONY: $(5)
ifeq ($(call get_page_source,$(1),$(5)),raw.xml)
$(5):: \
	$(5).convert2xml.xsl \
	$(5).xml \
	$(5).decl.xml \
	$(5).bemdecl.js \
	$(call add_suffixes,$(5),$(call pages_suffixes,$(2),$(3),$(4),$(call get_page_source,$(1),$(5))))
else
$(5):: \
	$(5).bemdecl.js \
	$(call add_suffixes,$(5),$(call pages_suffixes,$(2),$(3),$(4),$(call get_page_source,$(1),$(5))))
endif

$(5).raw.xml:: $(1)$(5).xml
	mkdir -p $$(@D)
	xsltproc --xinclude \
	    --param 'example-name' "'$(notdir $(5))'" \
	    --param 'example-params' "'$(wildcard $(1)$(5).params.xml)'" \
	    --param 'example-css' "'$(wildcard $(1)$(5).css)'" \
	    --param 'example-ie-css' "'$(wildcard $(1)$(5).ie.css)'" \
	    --param 'example-js' "'$(wildcard $(1)$(5).js)'" \
	    $(EXAMPLE2XSCRIPT_PARAMS) \
	    $(LEGO_PREFIX)tools/example2xscript.xsl $$< >$$@

$(5).bemjson.js:: $(1)$(5).bemjson.js
	mkdir -p $$(@D)
	cp -f $$< $$@

$(5).html:: $(5).bemhtml.js $(5).bemjson.js
	$(LEGO_PREFIX)tools/bemjson2html.js $$^ $$@

endef

$(call generate_block_examples_targets,$(SET_SOURCE),$(EXAMPLES))

all:: $(sort $(foreach example,$(EXAMPLES),$(call get_parent,$(example))))

.PHONY: clean
clean::
	-rm -rf i-* b-* l-*


# ================================ Сборка тестов


