# ================================ Переменные

YENV ?= development
YCSSJS ?= ycssjs
YCSSJS_DEBUG ?= false
YCSSJS_BUF ?= .ycssjs-buf
YCSSJS_FASTCGI ?= true

# ================================ Цели

ifneq ($(YCSSJS_FASTCGI),false)

_%:: %
	@echo == ycssjs: NOOP: $<

ycssjs::
	@echo == ycssjs: YENV=$(YENV), YCSSJS_FASTCGI=$(YCSSJS_FASCGI)

else

ifneq ($(YENV),development)


_%:: % | $(YCSSJS_BUF)
	echo $< >> 	$(YCSSJS_BUF)

ycssjs:: $(YCSSJS_BUF)
	files=$$(cat $<) && if [ -n "$$files" ]; then \
		echo $$files | \
			xargs $(if $(subst true,,$(YCSSJS_DEBUG)),,-L 1) \
				$(YCSSJS) --once=yes $(if $(subst development,,$(YENV)),,--minimize=no); fi
	@echo == ycssjs: $(YENV)
	@cat $< | tr '\n' ' ' && echo

$(YCSSJS_BUF)::
	@rm -f $@
	@touch $@

else

_%:: %
	$(YCSSJS) $< --once=yes --minimize=no

ycssjs::
	@echo == ycssjs: YENV=$(YENV), YCSSJS_FASTCGI=$(YCSSJS_FASCGI)

endif

endif

.PHONY: ycssjs
