<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    exclude-result-prefixes="lego"
    extension-element-prefixes="x ya func"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="yes"
    />

    <xsl:key name="blocks" match="lego:*[@b or lego:is-block(.)]" use="lego:block-full-name(.)"/>
    <xsl:key name="elems" match="lego:*[not(lego:is-block(.))]" use="lego:item-full-name(.)"/>
    <xsl:key name="mods" match="lego:*/@*[namespace-uri() = 'https://lego.yandex-team.ru']" use="lego:mod-full-name(.., .)"/>
    <xsl:key name="vals" match="lego:*/@*[namespace-uri() = 'https://lego.yandex-team.ru']" use="lego:val-full-name(.., .)"/>

    <func:function name="lego:block-full-name">
        <xsl:param name="node"/>
        <xsl:choose>
            <xsl:when test="$node/@b">
                <func:result select="$node/@b"/>
            </xsl:when>
            <xsl:otherwise>
                <func:result select="local-name($node)"/>
            </xsl:otherwise>
        </xsl:choose>
    </func:function>

    <func:function name="lego:elem-full-name">
        <xsl:param name="block"/>
        <xsl:param name="node"/>
        <func:result select="concat(lego:block-full-name($block), '__', local-name($node))"/>
    </func:function>

    <func:function name="lego:item-full-name">
        <xsl:param name="node"/>
        <xsl:choose>
            <xsl:when test="lego:is-block($node)">
                <func:result select="lego:block-full-name($node)"/>
            </xsl:when>
            <xsl:when test="$node/@b">
                <func:result select="lego:elem-full-name($node, $node)"/>
            </xsl:when>
            <xsl:otherwise>
                <func:result select="lego:elem-full-name($node/ancestor::lego:*[lego:is-block(.)][1], $node)"/>
            </xsl:otherwise>
        </xsl:choose>
    </func:function>

    <func:function name="lego:mod-full-name">
        <xsl:param name="item"/>
        <xsl:param name="node"/>
        <func:result select="concat(lego:item-full-name($item), '_', local-name($node))"/>
    </func:function>

    <func:function name="lego:val-full-name">
        <xsl:param name="item"/>
        <xsl:param name="node"/>
        <func:result select="concat(lego:mod-full-name($item, $node), '_', $node)"/>
    </func:function>

    <func:function name="lego:is-block">
        <xsl:param name="node"/>
        <func:result select="translate(substring(local-name($node), 1, 2), 'blegzi', '') = '-'"/>
    </func:function>

    <xsl:template match="/">
        <decl>
            <xsl:apply-templates select="//lego:*[
                generate-id() = generate-id(key('blocks', local-name())) or
                generate-id() = generate-id(key('blocks', @b))]"/>
        </decl>
    </xsl:template>

    <xsl:template match="lego:*">
        <xsl:param name="as-elem" select="false()"/>
        <xsl:variable name="name">
            <xsl:choose>
                <xsl:when test="
                    lego:is-block(.) or
                    (@b and not($as-elem) and not(ancestor::*[name() = concat('lego:', current()/@b)]))">block</xsl:when>
                <xsl:otherwise>elem</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:element name="{$name}">
            <xsl:attribute name="name">
                <xsl:choose>
                    <xsl:when test="$name = 'block'">
                        <xsl:value-of select="lego:block-full-name(.)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="local-name()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:apply-templates select="//lego:*/@*[
                generate-id() = generate-id(
                    key(
                        'mods',
                        lego:mod-full-name(current(), .)))]"/>
            <xsl:if test="$name = 'block'">
                <xsl:apply-templates select="//lego:*[
                    generate-id() = generate-id(
                        key(
                            'elems',
                            lego:elem-full-name(current(), .)))]">
                    <xsl:with-param name="as-elem" select="boolean(@b)"/>
                </xsl:apply-templates>
            </xsl:if>
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*"/>
    <xsl:template match="@lego:*">
        <mod name="{local-name()}">
            <xsl:for-each select="key('mods', lego:mod-full-name(.., .))[
                generate-id() = generate-id(
                    key(
                        'vals',
                        lego:val-full-name(.., .)))]">

                <val name="{.}"/>
            </xsl:for-each>
        </mod>
    </xsl:template>

</xsl:stylesheet>
