<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:func="http://exslt.org/functions"
    xmlns:ui="urn:unimport"
    xmlns:str="http://exslt.org/strings"
    extension-element-prefixes="x ya str func"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="no"
    />

    <xsl:key name="ui-stylesheet-templates-by-mode" match="ui:template" use="concat(ancestor::ui:stylesheet/@href, '._.', @mode)"/>
    <xsl:key name="ui-prefixes-by-value" match="ui:prefix" use="concat(@for, '._.', .)"/>
    <xsl:key name="ui-namespaces-by-name" match="ui:namespace" use="@name"/>

    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="ui:root[@turn = 'third']">
                <xsl:element name="xsl:stylesheet">
                    <xsl:apply-templates select="." mode="ui.prefixes">
                        <xsl:with-param name="for" select="'exclude-result-prefixes'"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="." mode="ui.prefixes">
                        <xsl:with-param name="for" select="'extension-element-prefixes'"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="ui:root/ui:stylesheet//ui:namespace" mode="ui.namespace"/>
                    <xsl:attribute name="version">1.0</xsl:attribute>
                    <xsl:apply-templates select="ui:root/ui:stylesheet" mode="ui.fourth"/>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <ui:root>
                    <xsl:choose>
                        <xsl:when test="xsl:stylesheet">
                            <xsl:attribute name="turn">first</xsl:attribute>
                            <xsl:apply-templates select="xsl:stylesheet" mode="ui.first">
                                <xsl:with-param name="root" select="true()"/>
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:when test="ui:root[@turn = 'first']">
                            <xsl:attribute name="turn">second</xsl:attribute>
                            <xsl:apply-templates select="ui:root/ui:stylesheet" mode="ui.second"/>
                        </xsl:when>
                        <xsl:when test="ui:root[@turn = 'second']">
                            <xsl:attribute name="turn">third</xsl:attribute>
                            <xsl:apply-templates select="ui:root/ui:stylesheet" mode="ui.third"/>
                        </xsl:when>
                    </xsl:choose>
                </ui:root>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="xsl:stylesheet" mode="ui.first">
        <xsl:param name="href"/>
        <xsl:param name="root"/>
        <xsl:apply-templates select="xsl:import" mode="ui.first"/>
        <ui:stylesheet>
            <xsl:if test="$href">
                <xsl:attribute name="href">
                    <xsl:value-of select="$href"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="$root">
                <xsl:attribute name="root">yes</xsl:attribute>
            </xsl:if>
            <xsl:for-each select="namespace::*">
                <ui:namespace name="{local-name()}">
                    <xsl:value-of select="."/>
                </ui:namespace>
            </xsl:for-each>
            <xsl:apply-templates select="@extension-element-prefixes | @exclude-result-prefixes" mode="ui.first"/>
            <xsl:for-each select="xsl:include">
                <xsl:variable name="doc" select="document(@href)/xsl:stylesheet"/>
                <xsl:apply-templates select="$doc/@*[
                    local-name() = 'extension-element-prefixes' or
                    local-name() = 'exclude-result-prefixes']" mode="ui.first"/>
                <xsl:for-each select="$doc/namespace::*">
                    <ui:namespace name="{local-name()}">
                        <xsl:value-of select="."/>
                    </ui:namespace>
                </xsl:for-each>
                <xsl:apply-templates select="$doc/xsl:import" mode="ui.first"/>
            </xsl:for-each>
            <xsl:apply-templates select="." mode="ui.copy-xsl"/>
        </ui:stylesheet>
    </xsl:template>

    <xsl:template match="@extension-element-prefixes | @exclude-result-prefixes" mode="ui.first">
        <xsl:variable name="for" select="local-name()"/>
        <xsl:for-each select="str:split(normalize-space(.), ' ')">
            <ui:prefix for="{$for}">
                <xsl:value-of select="."/>
            </ui:prefix>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="xsl:import" mode="ui.first">
        <xsl:apply-templates select="document(@href)/xsl:stylesheet" mode="ui.first">
            <xsl:with-param name="href" select="@href"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="*" mode="ui.second">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="ui.second"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*" mode="ui.second">
        <xsl:copy-of select="."/>
    </xsl:template>

    <xsl:template match="xsl:template" mode="ui.second">
        <xsl:variable name="stylesheet" select="ancestor::ui:stylesheet"/>
        <xsl:variable name="mode">
            <xsl:apply-templates select="." mode="ui.mode"/>
        </xsl:variable>
        <xsl:if test="not(@name) and $stylesheet/following-sibling::ui:stylesheet[.//ui:apply-imports[@mode = $mode]]">
            <ui:template>
                <xsl:apply-templates select="@*" mode="ui.second"/>
                <xsl:apply-templates select="$stylesheet" mode="ui.stylesheet-mode">
                    <xsl:with-param name="mode" select="$mode"/>
                </xsl:apply-templates>
                <xsl:apply-templates select="node()" mode="ui.second"/>
            </ui:template>
        </xsl:if>

        <xsl:variable name="current" select="current()"/>
        <xsl:if test="not(following::xsl:template[@match = string($current/@match) and string(@mode) = string($current/@mode) and string(@priority) = string($current/@priority)])">
            <xsl:copy>
                <xsl:apply-templates select="@* | node()" mode="ui.second"/>
            </xsl:copy>
        </xsl:if>
    </xsl:template>

    <xsl:template match="xsl:output[not(ancestor::ui:stylesheet/@root)]" mode="ui.second"/>

    <xsl:template match="xsl:stylesheet/xsl:variable | xsl:template[@name] | func:function" mode="ui.second">
        <xsl:if test="not(ancestor::ui:stylesheet/
            following-sibling::ui:stylesheet/xsl:stylesheet/
                xsl:*[local-name() = local-name(current()) and @name = current()/@name])">

            <xsl:copy>
                <xsl:apply-templates select="@* | node()" mode="ui.second"/>
            </xsl:copy>
        </xsl:if>
    </xsl:template>

    <xsl:template match="*" mode="ui.third">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="ui.third"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*" mode="ui.third">
        <xsl:copy-of select="."/>
    </xsl:template>

    <xsl:template match="ui:template" mode="ui.third">
        <xsl:variable name="stylesheet" select="ancestor::ui:stylesheet"/>
        <xsl:if test="generate-id() = generate-id(key('ui-stylesheet-templates-by-mode', concat($stylesheet/@href, '._.', @mode)))">
            <xsl:copy>
                <xsl:attribute name="match">* | /</xsl:attribute>
                <xsl:attribute name="mode"><xsl:value-of select="@mode"/></xsl:attribute>
                <xsl:element name="xsl:apply-templates">
                    <xsl:attribute name="select">.</xsl:attribute>
                    <xsl:apply-templates select="$stylesheet" mode="ui.prev-stylesheet-mode">
                        <xsl:with-param name="mode" select="@orig-mode"/>
                        <xsl:with-param name="elem" select="."/>
                    </xsl:apply-templates>
                </xsl:element>
            </xsl:copy>
        </xsl:if>
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="ui.third"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="ui:apply-imports" mode="ui.third">
        <xsl:variable name="stylesheet" select="ancestor::ui:stylesheet"/>
        <ui:apply-templates>
            <xsl:attribute name="select">.</xsl:attribute>
            <xsl:apply-templates select="$stylesheet" mode="ui.prev-stylesheet-mode">
                <xsl:with-param name="mode" select="@mode"/>
                <xsl:with-param name="elem" select="."/>
            </xsl:apply-templates>
        </ui:apply-templates>
    </xsl:template>

    <xsl:template match="*" mode="ui.fourth">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="ui.fourth"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*" mode="ui.fourth">
        <xsl:copy-of select="."/>
    </xsl:template>

    <xsl:template match="ui:stylesheet | xsl:stylesheet" mode="ui.fourth">
        <xsl:apply-templates mode="ui.fourth"/>
    </xsl:template>

    <xsl:template match="ui:template | ui:apply-templates | xsl:apply-templates" mode="ui.fourth">
        <xsl:element name="xsl:{local-name()}">
            <xsl:copy-of select="@mode | @match | @select"/>
            <xsl:apply-templates mode="ui.fourth"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="ui:prefix | ui:namespace" mode="ui.fourth"/>

    <xsl:template match="*" mode="ui.copy-xsl">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="ui.copy-xsl"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="xsl:import" mode="ui.copy-xsl"/>

    <xsl:template match="xsl:include" mode="ui.copy-xsl">
        <xsl:apply-templates select="document(@href)/xsl:stylesheet/*" mode="ui.copy-xsl"/>
    </xsl:template>

    <xsl:template match="xsl:apply-imports" mode="ui.copy-xsl">
        <ui:apply-imports>
            <xsl:attribute name="mode">
                <xsl:apply-templates select="ancestor::xsl:template" mode="ui.mode"/>
            </xsl:attribute>
        </ui:apply-imports>
    </xsl:template>

    <xsl:template match="@*" mode="ui.copy-xsl">
        <xsl:copy-of select="."/>
    </xsl:template>

    <xsl:template match="*" mode="ui.mode">
        <xsl:choose>
            <xsl:when test="@mode">
                <xsl:value-of select="@mode"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="'ui.default'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="*" mode="ui.stylesheet-mode">
        <xsl:param name="mode"/>
        <xsl:attribute name="mode">
            <xsl:value-of select="$mode"/>
            <xsl:text>.ui.</xsl:text>
            <xsl:value-of select="count(preceding-sibling::ui:stylesheet)"/>
        </xsl:attribute>
        <xsl:attribute name="orig-mode">
            <xsl:value-of select="$mode"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="*" mode="ui.prev-stylesheet-mode">
        <xsl:param name="mode"/>
        <xsl:param name="elem"/>
        <xsl:variable name="prev-stylesheet" select="preceding-sibling::ui:stylesheet[*/ui:template[@orig-mode = $mode]]"/>
        <xsl:choose>
            <xsl:when test="$prev-stylesheet">
                <xsl:apply-templates select="$prev-stylesheet" mode="ui.stylesheet-mode">
                    <xsl:with-param name="mode" select="$mode"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="mode">ui.default</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="*" mode="ui.prefixes">
        <xsl:param name="for"/>
        <xsl:attribute name="{$for}">
            <xsl:for-each select="/ui:root/ui:stylesheet/ui:prefix
                [generate-id() = generate-id(key('ui-prefixes-by-value', concat($for, '._.', .)))]">
                <xsl:if test="position() - 1">
                    <xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="."/>
            </xsl:for-each>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="*" mode="ui.namespace"/>
    <xsl:template match="*[@name != 'xsl' and @name != 'xml' and generate-id() = generate-id(key('ui-namespaces-by-name', @name))]" mode="ui.namespace">
        <xsl:attribute name="xmlns-xmlns-{@name}">
            <xsl:value-of select="."/>
        </xsl:attribute>
    </xsl:template>

</xsl:stylesheet>
