var sys = require('sys'),
    fs = require('fs'),
    path = require('path'),
    crypto = require('crypto');

exports.Step = require('./step');

exports.writeFile = function(fileName, fileContent) {
    try {
        fs.writeFileSync(fileName, fileContent, 'utf8');
    } catch (e) {
        console.log(fileName + ' : ' + e);
    }
};

exports.writeFileIfDiffers = function(fileName, fileContent) {
    if (exports.sha1sumStr(fileContent) == exports.sha1sumSync(fileName)) return;
    exports.writeFile(fileName, fileContent);
};

exports.readFile = function(fileName) {
    try {
        var res = path.existsSync(fileName)? fs.readFileSync(fileName, 'utf8') : '';
        res.charCodeAt(0) == 65279 && (res = res.slice(1));
        return res;
    } catch(e) {
        console.log(fileName + ' : ' + e);
        return '';
    }
};

exports.sha1sumSync = function(fileName) {
    return exports.sha1sumStr(exports.readFile(fileName));
};

exports.sha1sumStr = function(s) {
    var hash = crypto.createHash('sha1');
    hash.update(s);
    return hash.digest('base64');
};

exports.sha1sum = function(fileName, cb) {
    var stream = fs.ReadStream(fileName),
        hash = crypto.createHash('sha1');
    stream.addListener('data', function (data) {
        hash.update(data);
    });
    stream.addListener('error', function (err) {
        cb(err);
    });
    stream.addListener('end', function () {
        cb(null, hash.digest('base64'));
    });
};

exports.fixSha1Base64 = function (sha1) {
    return sha1.replace(/\+/g, '-').replace(/\//g, '_').replace(/^-+/, '').replace(/=$/, '');
};

exports.arrayUnique = function(arr) {
    var test = {}, res = [];
    arr.forEach(function(a){
        if (!test[a]) res.push(a);
        test[a] = true;
    });
    return res;
}

exports.log = function(o) {
    console.log(sys.inspect(o));
    return o;
};

exports.trim = function(string) {
    return string.replace(/^\s*|\s*$/, '');
}

exports.object = {
    update: function(dest, from) {
        Object.getOwnPropertyNames(from).forEach(function(name) {
            var destination = Object.getOwnPropertyDescriptor(from, name);
            Object.defineProperty(dest, name, destination);
        });
    }
};

exports.lpad = function(string, len, padChar) {
    var ch = padChar || ' ',
        string = string + '';

    while(string.length < len) {
        string = ch + string;
    }

    return string;
}

