<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:json="urn:yandex:json"
    xmlns:func="http://exslt.org/functions"
    xmlns:str="http://exslt.org/strings"
    extension-element-prefixes="func str"
    >

    <xsl:output
        encoding="UTF-8"
        method="text"
        indent="no"
        media-type="text/javascript"
        omit-xml-declaration="yes"
    />

    <xsl:strip-space elements="*"/>

    <xsl:template match="/">
        <xsl:text>(</xsl:text>
        <xsl:apply-templates mode="json"/>
        <xsl:text>)</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="json">
        <xsl:text>{</xsl:text>
            <xsl:apply-templates select="." mode="json-tag"/>
            <xsl:apply-templates select="." mode="json-attrs"/>
            <xsl:apply-templates select="." mode="json-content"/>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template match="@*" mode="json">
        <xsl:value-of select="json:quote(name())"/>
        <xsl:text>:</xsl:text>
        <xsl:value-of select="json:quote(.)"/>
    </xsl:template>

    <xsl:template match="text()" mode="json">
        <xsl:value-of select="json:quote(.)"/>
    </xsl:template>

    <xsl:template match="*" mode="json-tag">
        <xsl:text>"tag":</xsl:text>
        <xsl:value-of select="json:quote(name())"/>
    </xsl:template>

    <xsl:template match="*" mode="json-attrs"/>
    <xsl:template match="*[@*]" mode="json-attrs">
        <xsl:text>,"attrs":{</xsl:text>
        <xsl:for-each select="@*">
            <xsl:if test="position() - 1">,</xsl:if>
            <xsl:apply-templates select="." mode="json"/>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="json-content"/>
    <xsl:template match="*[* | text()]" mode="json-content">
        <xsl:text>,"content":</xsl:text>
        <xsl:variable name="content" select="* | text()"/>
        <xsl:choose>
            <xsl:when test="count($content) - 1">
                <xsl:text>[</xsl:text>
                    <xsl:for-each select="$content">
                        <xsl:if test="position() &gt; 1">,</xsl:if>
                        <xsl:apply-templates select="." mode="json"/>
                    </xsl:for-each>
                <xsl:text>]</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="$content" mode="json"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <func:function name="json:quote">
        <xsl:param name="str"/>
        <func:result select="concat('&quot;',
                str:replace(
                str:replace(
                str:replace(
                str:replace(
                str:replace(
                    $str,
                    '\', '\\'),
                    '&quot;', '\&quot;'),
                    '&#x9;', '\t'),
                    '&#xA;', '\n'),
                    '&#xD;', '\r'),
            '&quot;')"/>
    </func:function>

</xsl:stylesheet>
