<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<xsl:output method="text"/>

<!-- ############################################################################################################## -->

<xsl:variable name="cr"><xsl:text>
</xsl:text></xsl:variable>

<!-- ############################################################################################################## -->

<!-- блоки -->
<xsl:template match="lego:*[translate(substring(local-name(), 1, 2), 'blegzi', '') = '-']">
    <xsl:value-of select="concat(local-name(), '/', local-name(), $cr)"/>
    <!-- сперва выводим элементы -->
    <xsl:apply-templates select="lego:*">
        <xsl:with-param name="name" select="local-name()"/>
    </xsl:apply-templates>
    <!-- затем модификаторы -->
    <xsl:apply-templates select="@*">
        <xsl:with-param name="dir" select="local-name()"/>
        <xsl:with-param name="file" select="local-name()"/>
    </xsl:apply-templates>

    <xsl:apply-templates select="*[not(self::lego:*)]">
        <xsl:with-param name="name" select="local-name()"/>
    </xsl:apply-templates>
</xsl:template>

<xsl:template match="lego:*[@b]">
    <xsl:value-of select="concat(@b, '/', @b, $cr)"/>
    <!-- сперва выводим элементы -->
    <xsl:apply-templates select="." mode="elem">
        <xsl:with-param name="name" select="@b"/>
    </xsl:apply-templates>
</xsl:template>

<!-- элементы -->
<xsl:template match="lego:*">
    <xsl:param name="name"/>
    <xsl:apply-templates select="." mode="elem">
        <xsl:with-param name="name" select="$name"/>
    </xsl:apply-templates>
</xsl:template>

<xsl:template match="lego:*" mode="elem">
    <xsl:param name="name"/>
    <xsl:if test="$name">
        <xsl:variable name="dir" select="concat($name, '/', local-name())"/>
        <xsl:variable name="file" select="concat($name, '__', local-name())"/>

        <xsl:value-of select="concat($dir, '/', $file, $cr)"/>

        <xsl:apply-templates select="@*">
            <xsl:with-param name="dir" select="$dir"/>
            <xsl:with-param name="file" select="$file"/>
        </xsl:apply-templates>
    </xsl:if>

    <xsl:apply-templates select="lego:*">
        <xsl:with-param name="name" select="$name"/>
    </xsl:apply-templates>

    <xsl:apply-templates select="*[not(self::lego:*)]">
        <xsl:with-param name="name" select="$name"/>
    </xsl:apply-templates>
</xsl:template>

<xsl:template match="@*"/>

<!-- модификаторы -->
<xsl:template match="@*[namespace-uri() = 'https://lego.yandex-team.ru']">
<xsl:param name="dir"/>
<xsl:param name="file"/>
<xsl:variable name="value">
    <xsl:choose>
        <xsl:when test=". = ''"><xsl:value-of select="local-name()"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
    </xsl:choose>
</xsl:variable>

    <xsl:value-of select="concat($dir, '/_', local-name(), '/', $file, '_', local-name(), '_', $value, $cr)"/>
    <xsl:value-of select="concat($dir, '/_', local-name(), '/', $file, '_', local-name(), $cr)"/>
    <xsl:value-of select="concat($dir, '/_', local-name(), '/', $file, '_', $value, $cr)"/>
</xsl:template>

<xsl:template match="*[not(self::lego:*)]">
    <xsl:param name="name"/>
    <xsl:apply-templates select="*">
        <xsl:with-param name="name" select="$name"/>
    </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet>

