local keyCount = #KEYS;
local argCount = #ARGV;
if argCount ~= keyCount + 1 then
    error("expected " .. (keyCount + 1) .. " arguments (values for each key + TTL), " .. argCount .. " given");
end
local keysTTL = ARGV[argCount];

local results = {}
for i = 1, keyCount, 1 do
    local key = KEYS[i];
    local value = ARGV[i];
    if not redis.call('GET', key) then
        redis.call('PSETEX', key, keysTTL, value);
        results[i] = true;
    else
        results[i] = false;
    end
end

return results;
