local keyCount = #KEYS;
local argCount = #ARGV;
if argCount ~= keyCount then
    error("expected " .. keyCount .. " arguments (lock values for each key), " .. argCount .. " given");
end

local results = {}
for i = 1, keyCount, 1 do
    local key = KEYS[i];
    local value = ARGV[i];
    if redis.call('GET', key) == value then
        redis.call('DEL', key);
        results[i] = true;
    else
        results[i] = false;
    end
end

return results;
