package geo_regions;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod

    [%# Шаблон для geo_regions.pm  %]

    geo_regions.pm

    Модуль geo_regions.pm -- генерируемый, вручную исправлять его не надо, надо исправлять шаблон data/t/regions/all_regions.tmpl.pm
    и запускать скрипт protected/mk_regions.pl для перегенерации pm-файла

=cut

use strict;
use utf8;

use Hash::Util;

# символьные обозначения некоторых важных регионов
our $RUS = 225;
our $UKR = 187;
our $KAZ = 159;
our $BY  = 149;
our $MSK_REGION = 1; # Московская область ( включая Москву ;) )
our $TR = 983; # Turkey
our $MOSCOW = 213;
our $KRIM = 977;
our $SNG = 166;
our $UZB = 171;
our $ASIA = 183;

# типы регионов
our $COUNTRY = 3;
our $CITY = 6;
our $OVERSEAS_TERRITORY = 12;

our @REGIONS_FOR_GEO_SUGGEST = (
    [% regions_for_suggest_csv %]
);


# список стран
our @COUNTRY_REGIONS = (
    [% fields = ['region_id'];
       FOR l IN supported_langs;
        fields.push("name_" _ l);
       END;
    %]
    
    [%- FOR r = country_regions.nsort('region_id') %]
    {
        [%- FOR field IN fields %]
        [%- IF r.exists(field) %] [% field %] => '[% r.$field.replace("'","\\'") %]', [% END ~%]
        [% END -%]
    },
    [%- END %]
);

[% BLOCK make_georeg %]
# [% comment %]
our %[% georeg_hash_name %] = (
    [% FOR id = $georeg_var_name.keys.sort %]
        [% r = $georeg_var_name.$id %]
        [% id %] => {
            [%- FOR field IN name_aliases %]
            [% IF r.exists(field) %] [% field %] => '[% r.$field.replace("'","\\'") %]', [% END %]
            [%- END -%]
            [% FOR field = [ 'media', 'geo_flag', 'level', 'type' ] %]
            [% IF r.exists(field) %] [% field %] => [% r.$field %], [% END %]
            [%- END -%]
            [% FOR field = [ 'parents', 'childs' ] %]
            [% IF r.exists(field) %] [% field %] => [ [% r.$field.join(', ') %] ], [% END %]
            [%- END %]
        },
    [%- END %]
);
[% END %]

[% PROCESS make_georeg georeg_hash_name = 'GEOREG',        georeg_var_name = 'georeg',        comment = 'хэш всех известных регионов' %]
[% PROCESS make_georeg georeg_hash_name = 'GEOREG_FOR_RU', georeg_var_name = 'georeg_for_ru', comment = 'хэш всех известных регионов (транслокальный для Росиии)' %]
[% PROCESS make_georeg georeg_hash_name = 'GEOREG_API',    georeg_var_name = 'georeg_api',    comment = 'хэш всех известных регионов (для API c Крымом в корне)' %]

# уникальные алиасы для неуникальных названий регионов
our %GEOREG_UNIQ_ALIAS = (
    [% FOR id = georeg_uniq_alias.keys.sort %]
        [%- r = georeg_uniq_alias.$id %]
        [% id %] => {
            [%- FOR field = r.keys.sort %]
            [% field %] => '[% r.$field %]',
            [%- END %]
        },
    [%- END %]
);

# обратный ресолв алиасов в id
our %GEOREG_UNIQ_NAME = (
    [% FOR field = georeg_uniq_name.keys.sort %]
    [% field %] => {
        [%- r = georeg_uniq_name.$field %]
        [%- FOR name = r.keys.sort %]
        '[% name %]' => [% r.$name %],
        [%- END %]
    },
    [% END %]
);

# список станций метро
our %METRO = (
    [% FOR city = metro.keys.nsort %]
    [% city %] => [
        [%- FOR st = metro.$city %]
        {
            name => '[% st.name %]',
            region_id => '[% st.region_id %]',
        },
        [%- END %]
    ],
    [% END %]
);

# лочим ключи хэшей во избежание самозарождения элементов, ведущих к забавным и трудноуловимым багам

Hash::Util::lock_keys(%GEOREG);
Hash::Util::lock_keys(%GEOREG_FOR_RU);
Hash::Util::lock_keys(%GEOREG_API);
Hash::Util::lock_keys(%GEOREG_UNIQ_ALIAS);
Hash::Util::lock_keys(%GEOREG_UNIQ_NAME);
Hash::Util::lock_keys(%METRO);

1;
