var pageBlocks = process.env.PAGE_BLOCK || process.env.PAGE_BLOCKS;

module.exports = require('enb/lib/build-flow').create()
    .name('bemdecl-by-name')
    .target('target', '?.page-bemdecl.js')
    .useSourceText('bemdecl', '?.bemdecl.js')
    .needRebuild(function(cache) {
        var lastPages = cache.get('lastPagesBuilt');

        cache.set('lastPagesBuilt', pageBlocks);

        return lastPages !== pageBlocks;
    })
    .builder(function(bemdeclSource) {
        if (pageBlocks) {
            var sourceFunc = new Function('exports', bemdeclSource + '; return exports;'),
                blocks = sourceFunc({}).blocks,
                pageBlocksArr = pageBlocks.split(',');

            blocks = blocks.filter(function(block) {
                var name = block.name;

                return !block.name || !name.match(/^p-/) || (name.match(/^p-/) && pageBlocksArr.indexOf(name) !== -1);
            });

            return 'exports.blocks = ' + JSON.stringify(blocks, null, '  ') + ';';
        }

        return bemdeclSource;
    })
    .createTech();

