/**
 * @heliarian
 * Собираем все схемы контекста (файлы из папок блоков вида b-block.ctx.schema.js) и
 * генерим для каждого bemhtml.js - обертку
 * получившиеся данные складываем в общий файл  b-ctx-validator.bemhtml.js
 *
 */
var Vow = require('vow'),
    vowFs = require('vow-fs');

module.exports = require('enb/lib/build-flow').create()
    .name('bemhtml-validated')
    .target('target', 'b-ctx-validator.bemhtml.js')
    .useFileList('bemhtml.js')
    .useSourceText('schemas', '?.ctx.schema.js')
    .builder(function(sourceFiles, schemas) {
        var schemasParsed = JSON.parse(schemas);

        return Vow.all(sourceFiles.map(function(file) {
            var name = file.name.replace('.bemhtml.js', '');

            return vowFs.read(file.fullname, 'utf8')
                .then(function(data) {
                    var blockNameString;

                    if (schemasParsed[name]) {
                        //отделяем от b-block__elem elem
                        //на выходе получаем ['b-block__elem_elemModName_elemModVal', 'b-block', 'elem', 'modName', 'modVal', elemModName, elemModVal]
                        var splitRes = /^([^_]+)(?:_)?(?:_([^_]+))?(?:([^_]+)_([^_]+))?(?:_([^_]+)_([^_]+))?$/g.exec(name),
                            blockName = splitRes[1],
                            //может быть пустое
                            elemName = splitRes[2],
                            modName = splitRes[3],
                            modVal = splitRes[4],
                            elemModName = splitRes[5],
                            elemModVal = splitRes[6];

                        blockNameString = 'block(\'' + blockName + '\')';

                        if (modName && modVal) {
                            blockNameString += '.mod(\'' + modName + '\', \'' + modVal + '\')';
                        }

                        if (elemName) {
                            blockNameString += '.elem(\'' + elemName + '\')';
                        }

                        if (elemModName && elemModVal) {
                            blockNameString += '.elemMod(\'' + modName + '\', \'' + modVal + '\')';
                        }

                        return [
                            blockNameString + '.wrap()(function() {',
                            '    var validateResult = u.tv4.validateResult(this.ctx, ' + JSON.stringify(schemasParsed[name]) + ');',
                            '',
                            '    return validateResult.valid ?',
                            '        this.ctx :',
                            '        {',
                            '            block: \'b-ctx-validator\',',
                            '            js: { block: \'' + name + '\', error: validateResult.error },',
                            '            content: this.ctx',
                            '        };',
                            '});'
                        ].join('\n\n');
                    }

                    return '';
                });
        })).then(function(sources) {
            return sources.filter(function(source) { return !!source; }).join('\n');
        });
    })
    .createTech();
