/**
 * @heliarian, @cyn
 * Переопределение технологии enb-bemxjst/techs/bemhtml в которую добавлен useSourceFilename('validatorFileName', 'b-ctx-validator.bemhtml.js')
 * для подклейки к разработческой сборке автогенерящегося файла b-ctx-validator.bemhtml.js с проверкой входного контекста
 */
module.exports = require('enb-bemxjst/techs/bemhtml').buildFlow()
    .useSourceFilename('validatorFileName', 'b-ctx-validator.bemhtml.js')
    .builder(function (fileList, validatorFileName) {
        // don't add fat wrapper code of bem-xjst
        if (!this._forceBaseTemplates && fileList.length === 0) {
            return this._mockBEMHTML();
        }

        var filenames = this._getUniqueFilenames(fileList).concat(validatorFileName);

        return this._readFiles(filenames)
            .then(this._processSources, this)
            .then(this._compileBEMHTML, this);
    })
    .createTech();
