var Vow = require('vow'),
    vowFs = require('vow-fs');

module.exports = require('enb/lib/build-flow').create()
    .name('bemtree-xjst-i18n')
    .target('target', '?.all.bemtree.xjst.js')
    .useSourceListFilenames('langTargets', [])
    .useSourceText('bemhtmlTarget', '?.bemhtml.js')
    .useSourceText('bemtreeTarget', '?.bemtree.xjst.js')
    .builder(function(langFilenames, bemhtml, bemtree) {
        return Vow.all(
            langFilenames.map(function(filename) {
                return vowFs.read(filename);
            })
        ).then(function(langResults) {
            return [
                '(function() {',
                [bemhtml, bemtree].concat(langResults).join('\n'),
                'return function(data) {',
                    'try {',
                        'return BEMHTML.apply(BEMTREE.apply({ block: \'app-main\', data: data.data, funcs: data.funcs }));',
                    '} catch(e) {',
                        //v8 в исключениях умеет принимать только строку, поэтому перехватываем ошибку
                        // и кидаем исключение с ее стектрейсом
                        'throw \'BEMXJST ERROR \' + (e.stack || e.message || e)',
                    '}',
                '}',
                '})();'
            ]
                .join('\n');
        });
    })
    .createTech();
