var Vow = require('vow'),
    vowFs = require('vow-fs'),
    path = require('path');

module.exports = require('enb/lib/build-flow').create()
    .name('client-schema-json')
    .target('target', '?.client.schema.js')
    .useFileList('client.schema.json')
    .builder(function(sourceFiles) {

        var controllersSchemasDir = path.join(this.node.getRootDir(), '../cmd-schema'),
            extPattern = /\.schema\.json$/g,
            getFullName = function(file) { return file.fullname; },
            readJson = function(filepath) {
                return vowFs.read(filepath, 'utf8').then(function(content) {
                    return {
                        content: JSON.parse(content),
                        name: path.basename(filepath)
                    };
                });
            };

        return Vow.all(sourceFiles.map(getFullName).map(readJson))
            .then(function(sources) {
                var schemas = sources.reduce(function(schemas, source) {
                    var schema = source.content;

                    if (schema.id) schemas[schema.id] = schema;

                    return schemas;
                }, {});

                return vowFs.glob(controllersSchemasDir + '/**/*.schema.json')
                    .fail(function() { return []; })
                    .then(function(files) {
                        return Vow.all(files.map(readJson))
                            .then(function(files) {

                                var refs = files.reduce(function(refs, file) {
                                    var obj = file.content,
                                        id = obj.id === undefined ?
                                            file.name.replace(extPattern, '') :
                                            obj.id;

                                    refs[id] = obj;

                                    return refs;
                                }, {});

                                return '(function() { ' +
                                    'window.CLIENT_SCHEMAS = ' +  JSON.stringify(schemas) + ';' +
                                    'window.CLIENT_SCHEMA_REFS = ' +  JSON.stringify(refs) + ';' +
                                    '})();';
                            });
                    });
            });
    })
    .createTech();
