/*
 Данная технология применяется для умной разбивки больших CSS файлов.
 Такая необходимость возникает для IE 6, 7, 8, 9, так как эти раритетные браузеры не умеют обрабатывать
 файл с более чем 4096ю правилами CSS.
 Технология разбивает файл на части, а в конечную часть подключает импортом все предыдущие.

 Пример использования:

 nodeConfig.addTechs([
     require('./enb-techs/css-split')
 ]);

 */

var path = require('path'),
    Vow = require('vow'),
    vowFs = require('vow-fs'),
    buildFlow = require('enb/lib/build-flow');

module.exports = buildFlow.create()
    .name('css-split')
    .target('target', '_?.ie.css')
    .useSourceText('cssTarget', '?.css')
    .builder(function(cssSource) {
        var parts = splitCss(cssSource), // получаем разбитые на части css
            last = parts.pop(), // отдельно берем последнюю
            importStr = '', // строка с командами импорта
            namePattern = '_' + this.node.getTargetName() + '.ie.part%n.css';

        return Vow
            .all(parts.map(function(part, i) {
                var fileName = namePattern.replace('%n', i),
                    filePath = this.node.resolvePath(fileName);

                // добавляем импорт
                importStr += '@import url("' + fileName + '");\n';

                // создаем файлы для частей
                return vowFs.write(filePath, part);
            }, this))
            .then(function() {
                // когда все файлы будут созданы резолвим код исходного CSS файла, который запишет ENB
                //      добавив к нему строку импорта
                return importStr + last;
            });
    })
    .createTech();


/**
 * Разбивает строку, содержащую CSS код на набор строк с лимитом правил.
 *      Источник https://raw.githubusercontent.com/paulyoung/bless.js/master/lib/bless/parser.js
 *      Тесты тут https://github.com/SLonoed/css-split
 * @param {String} str строка CSS стилей
 * @param {Object} options параметры
 * @param {Number} [options.limit=4094] максимальное количество правил в файле
 * @returns {*}
 */
function splitCss(str, options) {
    options = options || {};

    var data = [],
        limit = options.limit || 4094,
        selectors = str.match(/(,|\{)/g),
        rules = str.match(/([^\{]+\{(?:[^\{\}]|\{[^\{\}]*\})*\})/g),
        numSelectors = 0,
        offset = 0,
        selectorCount = 0,
        matchCount,
        matchArray = [],
        regex = /(?:\s*@media\s*[^\{]*(\{))?(?:\s*(?:[^,\{]*(?:(,)|(\{)(?:[^\}]*\}))))/g,
        rule,
        noComments,
        matches,
        slice;

    if (!selectors) return [str];

    for (var i = 0, length = rules.length; i < length; i++) {

        matchArray = [];
        rule = rules[i];

        do {
            noComments = rule.replace(/(\/\*[^*]*\*+([^/*][^*]*\*+)*\/)/g, '');
            matches = regex.exec(noComments);

            if (matches) {
                for (var m = 1, matchesLength = matches.length; m < matchesLength; m++) {
                    var match = matches[m];

                    if (match) matchArray.push(match);
                }
            }
        } while (matches);

        matchCount = matchArray.length;

        if (selectorCount + matchCount > limit) {
            slice = rules.slice(offset, i);

            if (slice.length) {
                slice[0] = slice[0].replace(/^\s+/, '');
                data.push(slice.join(''));
            }

            offset = i;
            selectorCount = 0;
        }

        numSelectors += matchCount;
        selectorCount += matchCount;
    }

    rules = rules.slice(offset);
    data.push(rules.join(''));

    return data;
}


