/**
 * Технология для создания единого файла .ctx.schema.js из схем для конкретных блоков
 * Схема каждого блока лежит в папке блока с названием b-block.ctx-schema.json
 * Нужно для валидации входного контекста блоков в рантайме
 */
var Vow = require('vow'),
    vowFs = require('vow-fs'),
    path = require('path');


module.exports = require('enb/lib/build-flow').create()
    .name('ctx-schema-json')
    .useFileList('ctx-schema.json')
    .target('target', '?.ctx.schema.js')

    .builder(function(sourceFiles) {
        return Vow.all(sourceFiles.map(function(file) {
            return vowFs.read(file.fullname, 'utf8');
        }))
        .then(function(sources) {
            var schemas = {};

            sources.forEach(function(source) {
                var schema = JSON.parse(source);

                if (schema.id) {
                    schemas[schema.id] = schema;
                }
            });

            return JSON.stringify(schemas);
        });
    })
    .createTech();
