/**
 * Включает в js сборку локализованные файлы регионов из папок {block-name}/{block-name}.regions
 */

var Vow = require('vow'),
    vowFs = require('vow-fs');

module.exports = require('enb/lib/build-flow').create()
    .name('regions-json')
    .defineRequiredOption('lang')
    .target('target', '?.{lang}.regions.js')
    .useDirList('regions')
    .builder(function(dirs) {
        var lang = this._lang,
            defaultLang = 'ru';

        return Vow.all(
            dirs.map(function(dir) {
                var regionTreeFileData = dir.files.reduce(function(result, file) {
                        if (file.name.indexOf(lang + '.') === 0) {
                            result.current = file.fullname;
                        }

                        if (file.name.indexOf(defaultLang + '.') === 0) {
                            result.default = file.fullname;
                        }

                        return result
                    }, {}),
                    regionsTreeFile = regionTreeFileData.current || regionTreeFileData.default;

                return vowFs.read(regionsTreeFile, 'utf8')
                    .then(function(regionsData) {
                        return [
                            ';(function() {',
                                'u.register({ _REGIONS_TREE: ' + regionsData + ' });',
                            '})();'
                        ].join('\n');
                    });
            }));
    })
    .createTech();
