/**
 * Технология сборки общей json-схемы.
 * Собирает схемы из блоков (например, data3/desktop.blocks/p-campaign/p-campaign.schema.json) и папки cmd-schema (например, cmd-schema/showSearchPage.schema.json)
 * Первые попадают в результирующую схему по ключу - имени блока, вторые - по имени файла (оно же имя контроллера)
 * В обоих случаях, если в схеме на верхнем уровне есть поле id, ключом будет являться значение этого поля
 */
var Vow = require('vow'),
    vowFs = require('vow-fs'),
    path = require('path');

module.exports = require('enb/lib/build-flow').create()
    .name('schema-json')
    .target('target', '?.schema.js')
    .useFileList('schema.json')
    .builder(function(sourceFiles) {
        return Vow.all(sourceFiles.map(function(file) {
            return vowFs.read(file.fullname, 'utf8').then(function(content) {
                return {
                    content: content,
                    name: path.basename(file.fullname, '.schema.json')
                };
            });
        }))
        .then(function(sources) {
            var schemas = {};

            sources.forEach(function(source) {
                try {
                    var schema = (JSON.parse(source.content));
                    schemas[schema.id || source.name] = schema;
                } catch (err) {
                    throw new Error('Schema error [' + source.name + ']: ', err.message);
                }
            });

            return JSON.stringify(schemas);
        });
    })
    .createTech();
