var forbiddenBlocks = [
    'p-campaign-easy',
    'p-campaign-settings-view'
];

module.exports = {
    levels: ['common.blocks', 'desktop.blocks', 'node_modules/bricks/source.blocks'],
    profiles: {
        'forbidden-blocks': {
            handler: './walker-plugins/forbidden-blocks',
                handlerConfig: {
                    reporter: 'console',
                    names: forbiddenBlocks,
                    throwError: true
                }
        },

        'forbidden-blocks-teamcity': {
            handler: './walker-plugins/forbidden-blocks',
                handlerConfig: {
                    reporter: 'teamcity',
                    names: forbiddenBlocks
                }
        },

        // тесты
        'test-bundles': {
            handler: './walker-plugins/test-bundler',
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'test.bundles',
                devEntities: ['dev-page', 'dev-page_type_test'],
                defaultBundleConfig: {
                    targets: ['?.test-result.json'],
                    platform: 'desktop',
                    single: true,       // собирать общий бандл с шаблонами для клиента и сервера
                    coverage: false,     // считать покрытие кода тестами
                    prependLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        },

        // тесты
        'test-touch-bundles': {
            handler: './walker-plugins/test-bundler',
            levels: ['common.blocks', 'touch.blocks'],
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'test.touch.bundles',
                devEntities: ['dev-page', 'dev-page_type_test'],
                defaultBundleConfig: {
                    targets: ['?.test-result.json'],
                    platform: 'touch',
                    single: true,       // собирать общий бандл с шаблонами для клиента и сервера
                    coverage: false,     // считать покрытие кода тестами
                    prependLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        },

        'test-bundles-coverage': {
            handler: './walker-plugins/test-bundler',
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'test.bundles',
                devEntities: ['dev-page', 'dev-page_type_test'],
                defaultBundleConfig: {
                    targets: ['?.test-result.json'],
                    platform: 'desktop',
                    single: true,       // собирать общий бандл с шаблонами для клиента и сервера
                    coverage: true,     // считать покрытие кода тестами
                    prependLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        },

        'test-touch-bundles-coverage': {
            handler: './walker-plugins/test-bundler',
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'test.touch.bundles',
                devEntities: ['dev-page', 'dev-page_type_test'],
                defaultBundleConfig: {
                    targets: ['?.test-result.json'],
                    platform: 'touch',
                    single: true,       // собирать общий бандл с шаблонами для клиента и сервера
                    coverage: true,     // считать покрытие кода тестами
                    prependLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        },
        'test-report-console': {
            handler: './walker-plugins/test-reporter',
            handlerConfig: { reporter: 'console', throwError: true },
            levels: ['test.bundles', 'test.touch.bundles']  // TODO вывод уровня на котором упал тест (DIRECT-78147)
        },
        'coverage-report-console': {
            handler: './walker-plugins/coverage-reporter',
            handlerConfig: { reporter: 'console' },
            levels: ['test.bundles']
        },

        'test-report-teamcity': {
            handler: './walker-plugins/test-reporter',
            handlerConfig: { reporter: 'teamcity', throwError: true },
            levels: ['test.bundles']
        },
        'coverage-report-teamcity': {
            handler: './walker-plugins/coverage-reporter',
            handlerConfig: { reporter: 'teamcity' },
            levels: ['test.bundles']
        },
        'coverage-report-html': {
            handler: './walker-plugins/coverage-reporter',
            handlerConfig: { reporter: 'html' },
            levels: ['test.bundles']
        },

        'sandbox-bundles': {
            handler: './walker-plugins/test-bundler',
            handlerConfig: {
                resultPath: 'bundles.json',
                baseBundlePath: 'test.bundles',
                devEntities: ['dev-page', 'dev-page_type_sandbox'],
                defaultBundleConfig: {
                    platform: 'desktop',
                    single: true,        // собирать общий бандл с шаблонами для клиента и сервера
                    coverage: false,     // считать покрытие кода тестами
                    prependLevels: ['node_modules/direct-dev/blocks', 'test.blocks']
                }
            }
        }
    }
};
